/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.rats.input;

import adams.data.text.TextContainer;
import adams.flow.core.Actor;
import adams.flow.rest.RESTProvider;
import adams.flow.rest.RatsServer;
import adams.flow.standalone.rats.input.AbstractBufferedRatInput;
import adams.flow.standalone.rats.input.RatInput;
import adams.flow.standalone.rats.input.RatInputUser;

public class RESTTextReception
extends AbstractBufferedRatInput {
    private static final long serialVersionUID = -3681678330127394451L;
    protected RESTProvider m_WebService;

    public String globalInfo() {
        return "Uses a REST webservice for receiving text. Internally polls whether data has arrived.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("web-service", "webService", (Object)this.getDefaultWebService());
    }

    protected RESTProvider getDefaultWebService() {
        return new RatsServer();
    }

    public void setWebService(RESTProvider value) {
        this.m_WebService = value;
        this.m_WebService.setFlowContext((Actor)this.getOwner());
        if (this.m_WebService instanceof RatInputUser) {
            ((RatInputUser)this.m_WebService).setRatInput((RatInput)this);
        }
        this.reset();
    }

    public RESTProvider getWebService() {
        return this.m_WebService;
    }

    public String webServiceTipText() {
        return "The REST webservice provider to use.";
    }

    public Class generates() {
        return TextContainer.class;
    }

    protected String doReceive() {
        String result = null;
        if (!this.m_WebService.isRunning()) {
            this.m_WebService.setFlowContext((Actor)this.getOwner());
            if (this.m_WebService instanceof RatInputUser) {
                ((RatInputUser)this.m_WebService).setRatInput((RatInput)this);
            }
            result = this.m_WebService.start();
        }
        return result;
    }

    public void stopExecution() {
        this.m_WebService.stop();
        super.stopExecution();
    }
}

