/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.rats.input;

import adams.data.blob.BlobContainer;
import adams.flow.core.Actor;
import adams.flow.standalone.rats.input.AbstractBufferedRatInput;
import adams.flow.standalone.rats.input.RatInput;
import adams.flow.standalone.rats.input.RatInputUser;
import adams.flow.webservice.WebServiceProvider;
import adams.flow.webservice.blob.RatsBlobServiceWS;

public class WSBlobReception
extends AbstractBufferedRatInput {
    private static final long serialVersionUID = -3681678330127394451L;
    protected WebServiceProvider m_WebService;

    public String globalInfo() {
        return "Uses a webservice for retrieving blobs. Internally polls whether data has arrived.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("web-service", "webService", (Object)this.getDefaultWebService());
    }

    protected WebServiceProvider getDefaultWebService() {
        return new RatsBlobServiceWS();
    }

    public void setWebService(WebServiceProvider value) {
        this.m_WebService = value;
        this.m_WebService.setFlowContext((Actor)this.getOwner());
        if (this.m_WebService instanceof RatInputUser) {
            ((RatInputUser)this.m_WebService).setRatInput((RatInput)this);
        }
        this.reset();
    }

    public WebServiceProvider getWebService() {
        return this.m_WebService;
    }

    public String webServiceTipText() {
        return "The webservice provider to use.";
    }

    public Class generates() {
        return BlobContainer.class;
    }

    protected String doReceive() {
        String result = null;
        if (!this.m_WebService.isRunning()) {
            this.m_WebService.setFlowContext((Actor)this.getOwner());
            if (this.m_WebService instanceof RatInputUser) {
                ((RatInputUser)this.m_WebService).setRatInput((RatInput)this);
            }
            result = this.m_WebService.start();
        }
        return result;
    }

    public void stopExecution() {
        this.m_WebService.stop();
        super.stopExecution();
    }
}

