/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.rats.output;

import adams.flow.core.Actor;
import adams.flow.core.Unknown;
import adams.flow.standalone.rats.output.AbstractRatOutput;
import adams.flow.standalone.rats.output.webservice.AbstractWebserviceResponseDataPostProcessor;
import adams.flow.standalone.rats.output.webservice.NullPostProcessor;
import adams.flow.webservice.WebServiceClient;
import adams.flow.webservice.WebServiceClientConsumer;
import adams.flow.webservice.WebServiceClientProducer;
import com.example.customerservice.flow.UpdateCustomer;

public class WebserviceOutput
extends AbstractRatOutput {
    private static final long serialVersionUID = -3752727785209685369L;
    protected WebServiceClient m_Client;
    protected AbstractWebserviceResponseDataPostProcessor m_ResponsePostProcessor;

    public String globalInfo() {
        return "Allows to send data to webservices using the supplied client.\nIf the webservice client implements " + WebServiceClientProducer.class.getName() + " then the supplied post-processor can be used to inspect the response from the webservice, e.g., for inspecting any error messages.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("client", "client", (Object)this.getDefaultClient());
        this.m_OptionManager.add("response-post-processor", "responsePostProcessor", (Object)new NullPostProcessor());
    }

    protected WebServiceClient getDefaultClient() {
        return new UpdateCustomer();
    }

    protected String checkClient(WebServiceClient value) {
        if (!(value instanceof WebServiceClientConsumer)) {
            return "Does not implement " + WebServiceClientConsumer.class.getName() + "!";
        }
        return null;
    }

    public void setClient(WebServiceClient value) {
        String msg = this.checkClient(value);
        if (msg == null) {
            this.m_Client = value;
            this.m_Client.setOwner((Actor)this.getOwner());
            this.reset();
        } else {
            this.getLogger().severe("Failed to set client: " + msg);
        }
    }

    public WebServiceClient getClient() {
        return this.m_Client;
    }

    public String clientTipText() {
        return "The webservice client to use.";
    }

    public void setResponsePostProcessor(AbstractWebserviceResponseDataPostProcessor value) {
        this.m_ResponsePostProcessor = value;
        this.reset();
    }

    public AbstractWebserviceResponseDataPostProcessor getResponsePostProcessor() {
        return this.m_ResponsePostProcessor;
    }

    public String responsePostProcessorTipText() {
        return "The post-processor to use for the webservice response (if the client implements " + WebServiceClientProducer.class.getName() + ").";
    }

    public Class[] accepts() {
        if (this.m_Client != null) {
            return ((WebServiceClientConsumer)this.m_Client).accepts();
        }
        return new Class[]{Unknown.class};
    }

    protected String doTransmit() {
        String result = null;
        try {
            this.m_Client.setOwner((Actor)this.getOwner());
            ((WebServiceClientConsumer)this.m_Client).setRequestData(this.m_Input);
            this.m_Client.query();
        }
        catch (Exception e) {
            result = this.handleException("Failed to send data to webservice!", e);
        }
        if (this.m_Client.hasLastError()) {
            result = this.m_Client.getLastError();
        }
        if (result == null && this.m_Client instanceof WebServiceClientProducer) {
            try {
                Object response = ((WebServiceClientProducer)this.m_Client).getResponseData();
                this.m_ResponsePostProcessor.setFlowContext((Actor)this.getOwner());
                this.m_ResponsePostProcessor.postProcess(response);
                if (this.m_ResponsePostProcessor.hasLastError()) {
                    result = this.m_ResponsePostProcessor.getLastError();
                }
            }
            catch (Exception e) {
                result = this.handleException("Failed to post-process response data from webservice!", e);
            }
        }
        return result;
    }
}

