/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.webservice.blob;

import adams.data.blob.BlobContainer;
import adams.flow.core.Actor;
import adams.flow.core.RatsBlobHelper;
import adams.flow.webservice.AbstractWebServiceClientSink;
import adams.flow.webservice.WebserviceUtils;
import adams.flow.webservice.interceptor.outgoing.AbstractOutInterceptorGenerator;
import java.net.URL;
import javax.xml.ws.BindingProvider;
import nz.ac.waikato.adams.webservice.rats.blob.RatsBlobService;
import nz.ac.waikato.adams.webservice.rats.blob.RatsBlobServiceService;
import nz.ac.waikato.adams.webservice.rats.blob.UploadRequest;
import nz.ac.waikato.adams.webservice.rats.blob.UploadResponse;

public class Upload
extends AbstractWebServiceClientSink<BlobContainer> {
    private static final long serialVersionUID = -338043583699608760L;
    protected BlobContainer m_ContainerIn;
    protected String m_Format;

    public String globalInfo() {
        return "Stores a BlobContainer using the RATS text webservice.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("format", "format", (Object)"application/octet-stream");
    }

    public void setFormat(String value) {
        this.m_Format = value;
        this.reset();
    }

    public String getFormat() {
        return this.m_Format;
    }

    public String formatTipText() {
        return "The mime format type.";
    }

    public Class[] accepts() {
        return new Class[]{BlobContainer.class};
    }

    public URL getWsdlLocation() {
        return ((Object)((Object)this)).getClass().getClassLoader().getResource("wsdl/adams/RatsBlobService.wsdl");
    }

    public void setRequestData(BlobContainer value) {
        this.m_ContainerIn = value;
    }

    protected void doQuery() throws Exception {
        RatsBlobServiceService ratsServiceService = new RatsBlobServiceService(this.getWsdlLocation());
        RatsBlobService ratsService = ratsServiceService.getRatsBlobServicePort();
        WebserviceUtils.configureClient((Actor)this.m_Owner, (Object)ratsService, (int)this.m_ConnectionTimeout, (int)this.m_ReceiveTimeout, (String)(this.getUseAlternativeURL() ? this.getAlternativeURL() : null), null, (AbstractOutInterceptorGenerator)this.m_OutInterceptor);
        WebserviceUtils.enableSchemaValidation((BindingProvider)((BindingProvider)ratsService));
        UploadRequest request = new UploadRequest();
        request.setFilename(this.m_ContainerIn.getID());
        request.setFormat(this.m_Format);
        request.setBlob(RatsBlobHelper.containerToWebservice(this.m_ContainerIn));
        UploadResponse response = ratsService.upload(request);
        if (!response.isSuccess()) {
            throw new IllegalStateException(response.getMessage());
        }
    }
}

