/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.webservice.text;

import adams.data.text.TextContainer;
import adams.flow.core.Actor;
import adams.flow.core.RatsTextHelper;
import adams.flow.webservice.AbstractWebServiceClientSink;
import adams.flow.webservice.WebserviceUtils;
import adams.flow.webservice.interceptor.outgoing.AbstractOutInterceptorGenerator;
import java.net.URL;
import javax.xml.ws.BindingProvider;
import nz.ac.waikato.adams.webservice.rats.text.RatsTextService;
import nz.ac.waikato.adams.webservice.rats.text.RatsTextServiceService;
import nz.ac.waikato.adams.webservice.rats.text.UploadRequest;
import nz.ac.waikato.adams.webservice.rats.text.UploadResponse;

public class Upload
extends AbstractWebServiceClientSink<TextContainer> {
    private static final long serialVersionUID = -338043583699608760L;
    protected TextContainer m_ContainerIn;
    protected String m_Format;

    public String globalInfo() {
        return "Stores a TextContainer using the RATS text webservice.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("format", "format", (Object)"plain/text");
    }

    public void setFormat(String value) {
        this.m_Format = value;
        this.reset();
    }

    public String getFormat() {
        return this.m_Format;
    }

    public String formatTipText() {
        return "The text format type.";
    }

    public Class[] accepts() {
        return new Class[]{TextContainer.class};
    }

    public URL getWsdlLocation() {
        return ((Object)((Object)this)).getClass().getClassLoader().getResource("wsdl/adams/RatsTextService.wsdl");
    }

    public void setRequestData(TextContainer value) {
        this.m_ContainerIn = value;
    }

    protected void doQuery() throws Exception {
        RatsTextServiceService ratsServiceService = new RatsTextServiceService(this.getWsdlLocation());
        RatsTextService ratsService = ratsServiceService.getRatsTextServicePort();
        WebserviceUtils.configureClient((Actor)this.m_Owner, (Object)ratsService, (int)this.m_ConnectionTimeout, (int)this.m_ReceiveTimeout, (String)(this.getUseAlternativeURL() ? this.getAlternativeURL() : null), null, (AbstractOutInterceptorGenerator)this.m_OutInterceptor);
        WebserviceUtils.enableSchemaValidation((BindingProvider)((BindingProvider)ratsService));
        UploadRequest request = new UploadRequest();
        request.setId(this.m_ContainerIn.getID());
        request.setFormat(this.m_Format);
        request.setText(RatsTextHelper.containerToWebservice(this.m_ContainerIn));
        UploadResponse response = ratsService.upload(request);
        if (!response.isSuccess()) {
            throw new IllegalStateException(response.getMessage());
        }
    }
}

