/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.core.Utils;
import adams.data.blob.BlobContainer;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;
import gnu.trove.list.array.TByteArrayList;
import java.io.InputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.util.ByteArrayDataSource;
import nz.ac.waikato.adams.webservice.rats.blob.Blob;
import nz.ac.waikato.adams.webservice.rats.blob.Properties;
import nz.ac.waikato.adams.webservice.rats.blob.Property;

public class RatsBlobHelper {
    public static Blob containerToWebservice(BlobContainer input) {
        Blob result = new Blob();
        result.setData(new DataHandler((DataSource)new ByteArrayDataSource((byte[])input.getContent(), "application/octet-stream")));
        Properties props = new Properties();
        if (input.hasReport()) {
            Report report = input.getReport();
            for (AbstractField field : report.getFields()) {
                Property prop = new Property();
                prop.setKey(field.getName());
                prop.setType(nz.ac.waikato.adams.webservice.rats.blob.DataType.valueOf(field.getDataType().toRaw()));
                prop.setValue("" + report.getValue(field));
                props.getProp().add(prop);
            }
        }
        result.setProps(props);
        return result;
    }

    public static BlobContainer webserviceToContainer(Blob input) {
        BlobContainer result = new BlobContainer();
        TByteArrayList bytes = new TByteArrayList();
        try {
            int read;
            InputStream in = input.getData().getInputStream();
            while ((read = in.read()) != -1) {
                bytes.add((byte)read);
            }
            result.setContent((Object)bytes.toArray());
        }
        catch (Exception e) {
            result.getNotes().addError(RatsBlobHelper.class, Utils.throwableToString((Throwable)e));
        }
        Report report = new Report();
        if (input.getProps() != null) {
            for (Property prop : input.getProps().getProp()) {
                Field field = new Field(prop.getKey(), DataType.valueOf((String)prop.getType().toString()));
                report.addField((AbstractField)field);
                report.setValue((AbstractField)field, (Object)prop.getValue());
            }
        }
        result.setReport(report);
        return result;
    }
}

