/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.rats.input;

import adams.core.CleanUpHandler;
import adams.core.QuickInfoSupporter;
import adams.core.ShallowCopySupporter;
import adams.core.Utils;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingObject;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.flow.control.StorageName;
import adams.flow.control.StorageQueueHandler;
import adams.flow.core.Actor;
import adams.flow.core.QueueHelper;
import adams.flow.standalone.Rat;
import adams.flow.standalone.rats.input.RatInput;

public abstract class AbstractRatInput
extends AbstractOptionHandler
implements RatInput,
ShallowCopySupporter<AbstractRatInput>,
QuickInfoSupporter,
CleanUpHandler {
    private static final long serialVersionUID = 9152793366076258048L;
    protected Rat m_Owner;
    protected boolean m_Stopped;
    protected String m_LoggingPrefix;

    protected void initialize() {
        super.initialize();
        this.m_LoggingPrefix = "";
    }

    protected void configureLogger() {
        this.m_Logger = LoggingHelper.getLogger((String)this.m_LoggingPrefix);
        this.m_Logger.setLevel(this.m_LoggingLevel.getLevel());
    }

    @Override
    public String getFullName() {
        if (this.getOwner() != null) {
            return this.getOwner().getFullName() + "$" + this.getClass().getSimpleName();
        }
        return "???$" + this.getClass().getSimpleName();
    }

    protected void updatePrefix() {
        if (this.getOwner() != null) {
            this.m_LoggingPrefix = this.getFullName();
            this.m_Logger = null;
        }
    }

    @Override
    public void setOwner(Rat value) {
        this.m_Owner = value;
        this.updatePrefix();
    }

    @Override
    public Rat getOwner() {
        return this.m_Owner;
    }

    protected String handleException(String msg, Throwable t) {
        return Utils.handleException((LoggingObject)this, (String)msg, (Throwable)t);
    }

    public String getQuickInfo() {
        return null;
    }

    @Override
    public abstract Class generates();

    @Override
    public abstract boolean hasPendingOutput();

    @Override
    public abstract Object output();

    @Override
    public String setUp() {
        String result = null;
        if (this.m_Owner == null) {
            result = "No owning actor set!";
        }
        if (result == null) {
            this.updatePrefix();
        }
        return result;
    }

    protected String check() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWait(int msec) {
        if (msec == 0) {
            return;
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("doWait: " + msec);
        }
        int count = 0;
        while (count < msec && !this.m_Stopped) {
            try {
                int current = msec - 100;
                if (current <= 0) {
                    current = msec;
                }
                if (current > 100) {
                    current = 100;
                }
                AbstractRatInput abstractRatInput = this;
                synchronized (abstractRatInput) {
                    this.wait(current);
                }
                count += current;
            }
            catch (Exception exception) {}
        }
    }

    protected StorageQueueHandler getQueue(StorageName name) {
        return QueueHelper.getQueue((Actor)this.getOwner(), (StorageName)name);
    }

    protected abstract String doReceive();

    @Override
    public String receive() {
        this.m_Stopped = false;
        String result = this.check();
        if (result == null) {
            result = this.doReceive();
        }
        return result;
    }

    public AbstractRatInput shallowCopy() {
        return this.shallowCopy(false);
    }

    public AbstractRatInput shallowCopy(boolean expand) {
        return (AbstractRatInput)OptionUtils.shallowCopy((OptionHandler)this, (boolean)expand);
    }

    @Override
    public void stopExecution() {
        this.m_Stopped = true;
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Stopped");
        }
    }

    @Override
    public boolean isStopped() {
        return this.m_Stopped;
    }

    public void cleanUp() {
    }
}

