/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.Pausable;
import adams.flow.core.AbstractActor;
import adams.flow.core.AbstractDisplay;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.standalone.Rat;
import adams.flow.standalone.Rats;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.GUIHelper;
import adams.gui.core.ParameterPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;

public class RatControl
extends AbstractDisplay {
    private static final long serialVersionUID = 2777897240842864503L;
    protected List<AbstractControlPanel> m_ControlPanels;

    public String globalInfo() {
        return "Control actor for Rats/Rat actors.";
    }

    protected void initialize() {
        super.initialize();
        this.m_ControlPanels = new ArrayList<AbstractControlPanel>();
    }

    protected boolean getDefaultDisplayInEditor() {
        return true;
    }

    protected boolean deregisterInWrapUp() {
        return true;
    }

    public void clearPanel() {
    }

    protected BasePanel newPanel() {
        ParameterPanel param = new ParameterPanel();
        List list = ActorUtils.findClosestTypes((Actor)this, Rats.class, (boolean)true);
        for (Actor item : list) {
            Rats rats = (Rats)item;
            RatsControlPanel cpanel = new RatsControlPanel();
            cpanel.setActor(rats);
            param.addParameter(rats.getName(), (Component)((Object)cpanel));
            this.m_ControlPanels.add(cpanel);
            boolean inControl = false;
            for (int i = 0; i < rats.size(); ++i) {
                Rat rat = (Rat)rats.get(i);
                if (!rat.getShowInControl()) continue;
                inControl = true;
                RatControlPanel subcpanel = new RatControlPanel();
                subcpanel.setActor(rat);
                param.addParameter(" - " + rat.getName(), (Component)((Object)subcpanel));
                this.m_ControlPanels.add(subcpanel);
            }
            cpanel.setPausable(!inControl);
        }
        JPanel panel = new JPanel(new FlowLayout(2));
        JButton buttonStop = new JButton("Stop");
        buttonStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RatControl.this.getRoot().stopExecution();
            }
        });
        panel.add(buttonStop);
        BasePanel result = new BasePanel((LayoutManager)new BorderLayout());
        result.add((Component)new BaseScrollPane((Component)param), (Object)"Center");
        result.add((Component)panel, (Object)"South");
        return result;
    }

    protected Runnable newDisplayRunnable() {
        Runnable result = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (RatControl.this.getCreateFrame() && !RatControl.this.m_Frame.isVisible()) {
                    RatControl.this.m_Frame.setVisible(true);
                }
                for (AbstractControlPanel panel : RatControl.this.m_ControlPanels) {
                    panel.updateButtons();
                }
                AbstractActor abstractActor = RatControl.this.m_Self;
                synchronized (abstractActor) {
                    RatControl.this.m_Self.notifyAll();
                }
                RatControl.this.m_Updating = false;
            }
        };
        return result;
    }

    public void cleanUp() {
        this.m_ControlPanels.clear();
        super.cleanUp();
    }

    public static class RatControlPanel
    extends AbstractControlPanel<Rat> {
        private static final long serialVersionUID = 4516229240505598425L;
    }

    public static class RatsControlPanel
    extends AbstractControlPanel<Rats> {
        private static final long serialVersionUID = 4516229240505598425L;
    }

    public static abstract class AbstractControlPanel<T extends Actor & Pausable>
    extends BasePanel {
        private static final long serialVersionUID = -5965060223206287867L;
        protected T m_Actor;
        protected JButton m_ButtonPause;

        protected void initGUI() {
            super.initGUI();
            this.setLayout(new FlowLayout(0));
            this.m_ButtonPause = new JButton(GUIHelper.getIcon((String)"pause.gif"));
            this.m_ButtonPause.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.pauseOrResume();
                }
            });
            this.add(this.m_ButtonPause);
            this.updateButtons();
        }

        public void setActor(T value) {
            this.m_Actor = value;
            this.updateButtons();
        }

        public T getActor() {
            return this.m_Actor;
        }

        public void pauseOrResume() {
            if (this.m_Actor == null) {
                return;
            }
            if (((Pausable)this.m_Actor).isPaused()) {
                ((Pausable)this.m_Actor).resumeExecution();
            } else {
                ((Pausable)this.m_Actor).pauseExecution();
            }
            this.updateButtons();
        }

        public void updateButtons() {
            if (this.m_Actor == null) {
                return;
            }
            if (((Pausable)this.m_Actor).isPaused()) {
                this.m_ButtonPause.setIcon(GUIHelper.getIcon((String)"run.gif"));
            } else {
                this.m_ButtonPause.setIcon(GUIHelper.getIcon((String)"pause.gif"));
            }
        }

        public void setPausable(boolean value) {
            this.m_ButtonPause.setVisible(value);
        }

        public boolean isPausable() {
            return this.m_ButtonPause.isVisible();
        }
    }
}

