/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.rats.input;

import adams.core.QuickInfoHelper;
import adams.core.base.CronSchedule;
import adams.core.option.OptionHandler;
import adams.flow.core.EventHelper;
import adams.flow.standalone.rats.input.AbstractMetaRatInput;
import java.util.Date;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.Trigger;

public class Cron
extends AbstractMetaRatInput {
    private static final long serialVersionUID = 1143927005847523885L;
    public static final String KEY_OWNER = "owner";
    protected CronSchedule m_Schedule;
    protected Scheduler m_Scheduler;

    public String globalInfo() {
        return "Uses a cronjob for defining the execution of the base rat input.\nFor more information on the scheduler format see:\nhttp://www.quartz-scheduler.org/docs/tutorials/crontrigger.html";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("schedule", "schedule", (Object)new CronSchedule("0 0 1 * * ?"));
    }

    public void setSchedule(CronSchedule value) {
        this.m_Schedule = value;
        this.reset();
    }

    public CronSchedule getSchedule() {
        return this.m_Schedule;
    }

    public String scheduleTipText() {
        return "The schedule for executing the base rat input; format 'SECOND MINUTE HOUR DAYOFMONTH MONTH WEEKDAY [YEAR]'.";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"schedule", (Object)this.m_Schedule.getValue());
    }

    @Override
    public Class generates() {
        return this.m_Input.generates();
    }

    protected String receiveData() {
        String result = this.m_Input.receive();
        if (result != null) {
            while (this.m_Input.hasPendingOutput()) {
                this.m_Data.add(this.m_Input.output());
            }
        }
        return result;
    }

    @Override
    protected String callReceive() {
        String result = null;
        try {
            if (this.m_Scheduler == null) {
                this.m_Scheduler = EventHelper.getDefaultScheduler();
                JobDetail job = new JobDetail(this.getFullName() + ".job", this.getFullName() + ".group", CronJob.class);
                job.getJobDataMap().put((Object)KEY_OWNER, (Object)this);
                CronTrigger trigger = new CronTrigger(this.getFullName() + ".trigger", this.getFullName() + ".group", this.getFullName() + ".job", this.getFullName() + ".group", this.m_Schedule.getValue());
                this.m_Scheduler.addJob(job, true);
                Date first = this.m_Scheduler.scheduleJob((Trigger)trigger);
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("First execution of actor: " + first);
                }
                this.m_Scheduler.start();
            } else {
                this.doWait(100);
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to set up cron job: ", e);
        }
        return result;
    }

    protected void stopScheduler() {
        if (this.m_Scheduler != null) {
            try {
                this.m_Scheduler.shutdown(true);
                this.m_Scheduler = null;
            }
            catch (Exception e) {
                this.handleException("Error shutting down scheduler:", e);
            }
        }
    }

    @Override
    public void stopExecution() {
        this.stopScheduler();
        super.stopExecution();
    }

    public static class CronJob
    implements Job {
        public void execute(JobExecutionContext context) throws JobExecutionException {
            Cron owner = (Cron)context.getJobDetail().getJobDataMap().get((Object)Cron.KEY_OWNER);
            if (owner.getOwner().isPaused()) {
                return;
            }
            String result = owner.receiveData();
            if (result != null) {
                owner.getLogger().warning(result);
            }
        }
    }
}

