/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.rats.input;

import adams.core.AtomicMoveSupporter;
import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.standalone.rats.input.AbstractRatInput;
import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class DirWatch
extends AbstractRatInput
implements AtomicMoveSupporter {
    private static final long serialVersionUID = -6772954304997860394L;
    protected PlaceholderDirectory m_Source;
    protected WatchEventKind[] m_Events;
    protected int m_WaitPoll;
    protected int m_WaitList;
    protected boolean m_MoveFiles;
    protected boolean m_AtomicMove;
    protected PlaceholderDirectory m_Target;
    protected List<String> m_Files;
    protected transient WatchService m_Watch;

    public String globalInfo() {
        return "Watches for file changes in a directory and forwards the affected files.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("source", "source", (Object)new PlaceholderDirectory());
        this.m_OptionManager.add("event", "events", (Object)new WatchEventKind[]{WatchEventKind.CREATE});
        this.m_OptionManager.add("wait-poll", "waitPoll", (Object)50, (Number)0, null);
        this.m_OptionManager.add("wait-list", "waitList", (Object)0, (Number)0, null);
        this.m_OptionManager.add("move-files", "moveFiles", (Object)false);
        this.m_OptionManager.add("atomic-move", "atomicMove", (Object)false);
        this.m_OptionManager.add("target", "target", (Object)new PlaceholderDirectory());
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Files = new ArrayList<String>();
    }

    protected void reset() {
        super.reset();
        this.stopWatchService();
    }

    public void setSource(PlaceholderDirectory value) {
        this.m_Source = value;
        this.reset();
    }

    public PlaceholderDirectory getSource() {
        return this.m_Source;
    }

    public String sourceTipText() {
        return "The directory to watch.";
    }

    public void setEvents(WatchEventKind[] value) {
        this.m_Events = value;
        this.reset();
    }

    public WatchEventKind[] getEvents() {
        return this.m_Events;
    }

    public String eventsTipText() {
        return "The kind of events to report.";
    }

    public void setWaitPoll(int value) {
        if (value >= 0) {
            this.m_WaitPoll = value;
            this.reset();
        } else {
            this.getLogger().warning("Number of milli-seconds to wait must be >=0, provided: " + value);
        }
    }

    public int getWaitPoll() {
        return this.m_WaitPoll;
    }

    public String waitPollTipText() {
        return "The number of milli-seconds to wait before polling again whether files have arrived.";
    }

    public void setWaitList(int value) {
        if (value >= 0) {
            this.m_WaitList = value;
            this.reset();
        } else {
            this.getLogger().warning("Number of milli-seconds to wait must be >=0, provided: " + value);
        }
    }

    public int getWaitList() {
        return this.m_WaitList;
    }

    public String waitListTipText() {
        return "The number of milli-seconds to wait after listing the files.";
    }

    public void setMoveFiles(boolean value) {
        this.m_MoveFiles = value;
        this.reset();
    }

    public boolean getMoveFiles() {
        return this.m_MoveFiles;
    }

    public String moveFilesTipText() {
        return "If enabled, the files get moved to the specified directory first before being transmitted (with their new filename).";
    }

    public void setAtomicMove(boolean value) {
        this.m_AtomicMove = value;
        this.reset();
    }

    public boolean getAtomicMove() {
        return this.m_AtomicMove;
    }

    public String atomicMoveTipText() {
        return "If true, then an atomic move operation will be attempted (NB: not supported by all operating systems).";
    }

    public void setTarget(PlaceholderDirectory value) {
        this.m_Target = value;
        this.reset();
    }

    public PlaceholderDirectory getTarget() {
        return this.m_Target;
    }

    public String targetTipText() {
        return "The directory to move the files to before transmitting their names.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"source", (Object)this.getSource(), (String)"source: ");
        result = QuickInfoHelper.toString((OptionHandler)this, (String)"events", (Object)Utils.flatten((Object[])this.getEvents(), (String)"/"), (String)", events: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"waitList", (Object)this.getWaitList(), (String)", wait-list: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"moveFiles", (Object)(this.getMoveFiles() ? "move" : "keep"), (String)", ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"target", (Object)this.getTarget(), (String)", target: ");
        return result;
    }

    @Override
    public Class generates() {
        return String.class;
    }

    @Override
    public String check() {
        String result = super.check();
        if (result == null && !this.getSource().exists()) {
            result = "Source directory does not exist: " + this.getSource();
        }
        if (result == null && !this.getSource().isDirectory()) {
            result = "Source is not a directory: " + this.getSource();
        }
        if (this.m_MoveFiles) {
            if (result == null && !this.getTarget().exists()) {
                result = "Target directory does not exist: " + this.getTarget();
            }
            if (result == null && !this.getTarget().isDirectory()) {
                result = "Target is not a directory: " + this.getTarget();
            }
        }
        return result;
    }

    @Override
    protected String doReceive() {
        int i;
        String result = null;
        Path dir = this.m_Source.toPath();
        ArrayList<String> files = new ArrayList<String>();
        if (this.m_Watch == null) {
            try {
                WatchEvent.Kind[] events = new WatchEvent.Kind[this.m_Events.length];
                for (i = 0; i < this.m_Events.length; ++i) {
                    events[i] = this.m_Events[i].getEventKind();
                }
                this.m_Watch = FileSystems.getDefault().newWatchService();
                dir.register(this.m_Watch, events);
            }
            catch (Exception e) {
                result = this.handleException("Failed to initialize watch service!", e);
            }
        }
        if (result == null) {
            while (files.size() == 0 && !this.m_Stopped) {
                WatchKey key;
                try {
                    key = this.m_Watch.poll(this.m_WaitPoll, TimeUnit.MILLISECONDS);
                    if (key == null) {
                        continue;
                    }
                }
                catch (Exception e) {
                    result = this.handleException("Failed to obtain files!", e);
                    break;
                }
                for (WatchEvent<?> event : key.pollEvents()) {
                    WatchEvent.Kind<?> kind = event.kind();
                    if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                    WatchEvent<?> ev = event;
                    Path name = (Path)ev.context();
                    Path child = dir.resolve(name);
                    files.add(child.toFile().getAbsolutePath());
                }
                boolean valid = key.reset();
                if (valid) continue;
                result = "Directory " + this.m_Source + " no longer valid??";
                break;
            }
        }
        if (this.m_MoveFiles) {
            for (i = 0; i < files.size(); ++i) {
                PlaceholderFile file = new PlaceholderFile((String)files.get(i));
                try {
                    if (!FileUtils.move((File)file, (File)this.m_Target, (boolean)this.m_AtomicMove)) {
                        result = "Failed to move '" + file + "' to '" + this.m_Target + "'!";
                    } else {
                        files.set(i, this.m_Target.getAbsolutePath() + File.separator + file.getName());
                    }
                }
                catch (Exception e) {
                    result = "Failed to move '" + file + "' to '" + this.m_Target + "': " + Utils.throwableToString((Throwable)e);
                }
                if (result != null) break;
            }
        }
        if (result == null) {
            this.m_Files.addAll(files);
        }
        return result;
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_Files.size() > 0;
    }

    @Override
    public Object output() {
        return this.m_Files.remove(0);
    }

    protected void stopWatchService() {
        if (this.m_Watch != null) {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Stopping watch service...");
            }
            try {
                this.m_Watch.close();
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("Watch service stopped!");
                }
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Stopping of watch service failed?", e);
            }
            this.m_Watch = null;
        }
    }

    @Override
    public void stopExecution() {
        this.stopWatchService();
        super.stopExecution();
    }

    public static enum WatchEventKind {
        CREATE(StandardWatchEventKinds.ENTRY_CREATE),
        MODIFY(StandardWatchEventKinds.ENTRY_MODIFY),
        DELETE(StandardWatchEventKinds.ENTRY_DELETE);

        private WatchEvent.Kind<Path> m_EventKind;

        private WatchEventKind(WatchEvent.Kind<Path> eventKind) {
            this.m_EventKind = eventKind;
        }

        public WatchEvent.Kind<Path> getEventKind() {
            return this.m_EventKind;
        }
    }
}

