/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.Variables;
import adams.core.option.OptionHandler;
import adams.flow.control.SubProcess;
import adams.flow.core.AbstractActor;
import adams.flow.core.Actor;
import adams.flow.core.ActorHandlerInfo;
import adams.flow.core.Compatibility;
import adams.flow.core.InternalActorHandler;
import adams.flow.core.MutableActorHandler;
import adams.flow.standalone.AbstractStandaloneGroupItem;
import adams.flow.standalone.rats.DummyInput;
import adams.flow.standalone.rats.DummyOutput;
import adams.flow.standalone.rats.RatInput;
import adams.flow.standalone.rats.RatOutput;
import adams.flow.standalone.rats.RatRunnable;

public class Rat
extends AbstractStandaloneGroupItem
implements MutableActorHandler,
InternalActorHandler {
    private static final long serialVersionUID = -154461277343021604L;
    protected RatInput m_Receiver;
    protected SubProcess m_Actors;
    protected RatOutput m_Transmitter;
    protected RatRunnable m_Runnable;

    public String globalInfo() {
        return "Defines a single reception/transmission setup.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("receiver", "receiver", (Object)new DummyInput());
        this.m_OptionManager.add("actor", "actors", (Object)new AbstractActor[0]);
        this.m_OptionManager.add("transmitter", "transmitter", (Object)new DummyOutput());
    }

    protected void initialize() {
        super.initialize();
        this.m_Actors = new SubProcess();
        this.m_Actors.setAllowEmpty(true);
    }

    public void setReceiver(RatInput value) {
        this.m_Receiver = value;
        this.m_Receiver.setOwner((AbstractActor)this);
        this.reset();
    }

    public RatInput getReceiver() {
        return this.m_Receiver;
    }

    public String receiverTipText() {
        return "The receiver to use.";
    }

    public SubProcess getActorHandler() {
        return this.m_Actors;
    }

    public void setActors(AbstractActor[] value) {
        this.m_Actors.setActors(value);
        this.reset();
    }

    public AbstractActor[] getActors() {
        return this.m_Actors.getActors();
    }

    public String actorsTipText() {
        return "The actors for transforming the data obtained by the receiver before sending it to the transmitter.";
    }

    public void setTransmitter(RatOutput value) {
        this.m_Transmitter = value;
        this.m_Transmitter.setOwner((AbstractActor)this);
        this.reset();
    }

    public RatOutput getTransmitter() {
        return this.m_Transmitter;
    }

    public String transmitterTipText() {
        return "The transmitter to use.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"receiver", (Object)this.m_Receiver, (String)"receiver: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"transmitter", (Object)this.m_Transmitter, (String)", transmitter: ");
        return result;
    }

    public ActorHandlerInfo getActorHandlerInfo() {
        return this.m_Actors.getActorHandlerInfo();
    }

    public String check() {
        return this.m_Actors.check();
    }

    public int size() {
        return this.m_Actors.size();
    }

    public AbstractActor get(int index) {
        return this.m_Actors.get(index);
    }

    public void set(int index, AbstractActor actor) {
        this.m_Actors.set(index, actor);
    }

    public int indexOf(String actor) {
        return this.m_Actors.indexOf(actor);
    }

    public AbstractActor firstActive() {
        return this.m_Actors.firstActive();
    }

    public AbstractActor lastActive() {
        return this.m_Actors.lastActive();
    }

    public void add(AbstractActor actor) {
        this.m_Actors.add(actor);
    }

    public void add(int index, AbstractActor actor) {
        this.m_Actors.add(index, actor);
    }

    public AbstractActor remove(int index) {
        return this.m_Actors.remove(index);
    }

    public void removeAll() {
        this.m_Actors.removeAll();
    }

    protected void forceVariables(Variables value) {
        super.forceVariables(value);
        this.m_Actors.setVariables(value);
    }

    public Actor getInternalActor() {
        return this.m_Actors;
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_Actors.setParent((AbstractActor)this);
            result = this.m_Actors.setUp();
        }
        if (result == null) {
            Compatibility comp = new Compatibility();
            if (this.m_Actors.active() > 0) {
                if (!comp.isCompatible(new Class[]{this.m_Receiver.generates()}, this.m_Actors.accepts())) {
                    result = "Receiver not compatible with actors: " + Utils.classToString((Class)this.m_Receiver.generates()) + " != " + Utils.classesToString((Class[])this.m_Actors.accepts());
                }
                if (result == null && !comp.isCompatible(this.m_Actors.generates(), this.m_Transmitter.accepts())) {
                    result = "Actors not compatible with transmitter: " + Utils.classesToString((Class[])this.m_Actors.generates()) + " != " + Utils.classesToString((Class[])this.m_Transmitter.accepts());
                }
            } else if (!comp.isCompatible(new Class[]{this.m_Receiver.generates()}, this.m_Transmitter.accepts())) {
                result = "Receiver not compatible with transmitter: " + Utils.classToString((Class)this.m_Receiver.generates()) + " != " + Utils.classesToString((Class[])this.m_Transmitter.accepts());
            }
            if (result == null) {
                result = this.m_Receiver.setUp();
            }
            if (result == null) {
                result = this.m_Transmitter.setUp();
            }
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        try {
            this.m_Runnable = new RatRunnable(this);
            this.m_Runnable.setLoggingLevel(this.getLoggingLevel());
            new Thread((Runnable)((Object)this.m_Runnable)).start();
        }
        catch (Exception e) {
            result = this.handleException("Failed to execute!", e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopIfNecessary() {
        if (!this.m_Stopped) {
            this.m_Receiver.stopExecution();
            this.m_Actors.stopExecution();
            this.m_Transmitter.stopExecution();
            if (this.m_Runnable != null) {
                this.m_Runnable.stopExecution();
                while (this.m_Runnable.isRunning()) {
                    try {
                        Rat rat = this;
                        synchronized (rat) {
                            ((Object)((Object)this)).wait(100L);
                        }
                    }
                    catch (Exception exception) {
                    }
                }
                this.m_Runnable = null;
            }
        }
    }

    public void stopExecution() {
        this.stopIfNecessary();
        super.stopExecution();
    }

    public void wrapUp() {
        if (this.m_Runnable != null) {
            this.stopIfNecessary();
        }
        this.m_Actors.wrapUp();
        super.wrapUp();
    }

    public void cleanUp() {
        this.m_Actors.cleanUp();
        super.cleanUp();
    }
}

