/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.rats;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.base.BaseRegExp;
import adams.core.io.DirectoryLister;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.standalone.rats.AbstractRatInput;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class FileLister
extends AbstractRatInput {
    private static final long serialVersionUID = 4089376907540465883L;
    protected DirectoryLister m_Lister;
    protected List<String> m_Files;
    protected int m_WaitList;
    protected boolean m_MoveFiles;
    protected PlaceholderDirectory m_Target;

    public String globalInfo() {
        return "Polls files in a directory and forwards them.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("source", "source", (Object)new PlaceholderDirectory());
        this.m_OptionManager.add("regexp", "regExp", (Object)new BaseRegExp(".*"));
        this.m_OptionManager.add("max-files", "maxFiles", (Object)-1, (Number)-1, null);
        this.m_OptionManager.add("sorting", "sorting", (Object)DirectoryLister.Sorting.NO_SORTING);
        this.m_OptionManager.add("sort-descending", "sortDescending", (Object)false);
        this.m_OptionManager.add("wait-list", "waitList", (Object)0, (Number)0, null);
        this.m_OptionManager.add("move-files", "moveFiles", (Object)false);
        this.m_OptionManager.add("target", "target", (Object)new PlaceholderDirectory());
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Lister = new DirectoryLister();
        this.m_Lister.setListDirs(false);
        this.m_Lister.setListFiles(true);
        this.m_Lister.setRecursive(false);
        this.m_Files = new ArrayList<String>();
    }

    public void setSource(PlaceholderDirectory value) {
        this.m_Lister.setWatchDir(value);
        this.reset();
    }

    public PlaceholderDirectory getSource() {
        return this.m_Lister.getWatchDir();
    }

    public String sourceTipText() {
        return "The directory to watch for incoming files.";
    }

    public void setRegExp(BaseRegExp value) {
        this.m_Lister.setRegExp(value);
        this.reset();
    }

    public BaseRegExp getRegExp() {
        return this.m_Lister.getRegExp();
    }

    public String regExpTipText() {
        return "The regular expression that the files must match.";
    }

    public void setMaxFiles(int value) {
        this.m_Lister.setMaxItems(value);
        this.reset();
    }

    public int getMaxFiles() {
        return this.m_Lister.getMaxItems();
    }

    public String maxFilesTipText() {
        return "The maximum number of files to list; -1 for unlimited.";
    }

    public void setSorting(DirectoryLister.Sorting value) {
        this.m_Lister.setSorting(value);
        this.reset();
    }

    public DirectoryLister.Sorting getSorting() {
        return this.m_Lister.getSorting();
    }

    public String sortingTipText() {
        return "The type of sorting to perform.";
    }

    public void setSortDescending(boolean value) {
        this.m_Lister.setSortDescending(value);
        this.reset();
    }

    public boolean getSortDescending() {
        return this.m_Lister.getSortDescending();
    }

    public String sortDescendingTipText() {
        return "If enabled, the sort direction is descending.";
    }

    public void setWaitList(int value) {
        if (value >= 0) {
            this.m_WaitList = value;
            this.reset();
        } else {
            this.getLogger().warning("Number of milli-seconds to wait must be >=0, provided: " + value);
        }
    }

    public int getWaitList() {
        return this.m_WaitList;
    }

    public String waitListTipText() {
        return "The number of milli-seconds to wait after listing the files.";
    }

    public void setMoveFiles(boolean value) {
        this.m_MoveFiles = value;
        this.reset();
    }

    public boolean getMoveFiles() {
        return this.m_MoveFiles;
    }

    public String moveFilesTipText() {
        return "If enabled, the files get moved to the specified directory first before being transmitted (with their new filename).";
    }

    public void setTarget(PlaceholderDirectory value) {
        this.m_Target = value;
        this.reset();
    }

    public PlaceholderDirectory getTarget() {
        return this.m_Target;
    }

    public String targetTipText() {
        return "The directory to move the files to before transmitting their names.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"source", (Object)this.getSource(), (String)"source: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"regExp", (BaseRegExp)this.getRegExp(), (String)", regexp: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"waitList", (Object)this.getWaitList(), (String)", wait-list: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"moveFiles", (Object)(this.getMoveFiles() ? "move" : "keep"), (String)", ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"target", (Object)this.getTarget(), (String)", target: ");
        return result;
    }

    @Override
    public String check() {
        String result = super.check();
        if (result == null && !this.getSource().exists()) {
            result = "Source directory does not exist: " + this.getSource();
        }
        if (result == null && !this.getSource().isDirectory()) {
            result = "Source is not a directory: " + this.getSource();
        }
        if (this.m_MoveFiles) {
            if (result == null && !this.getTarget().exists()) {
                result = "Target directory does not exist: " + this.getTarget();
            }
            if (result == null && !this.getTarget().isDirectory()) {
                result = "Target is not a directory: " + this.getTarget();
            }
        }
        return result;
    }

    @Override
    public Class generates() {
        return String.class;
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_Files.size() > 0;
    }

    @Override
    public Object output() {
        return this.m_Files.remove(0);
    }

    @Override
    protected String doReceive() {
        String result = null;
        String[] files = this.m_Lister.list();
        this.doWait(this.m_WaitList);
        if (this.m_MoveFiles) {
            for (int i = 0; i < files.length; ++i) {
                PlaceholderFile file = new PlaceholderFile(files[i]);
                try {
                    if (!FileUtils.move((File)file, (File)this.m_Target)) {
                        result = "Failed to move '" + file + "' to '" + this.m_Target + "'!";
                    } else {
                        files[i] = this.m_Target.getAbsolutePath() + File.separator + file.getName();
                    }
                }
                catch (Exception e) {
                    result = "Failed to move '" + file + "' to '" + this.m_Target + "': " + Utils.throwableToString((Throwable)e);
                }
                if (result != null) break;
            }
        }
        if (result == null) {
            this.m_Files.addAll(Arrays.asList(files));
        }
        return result;
    }
}

