/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.rats;

import adams.flow.core.RunnableWithLogging;
import adams.flow.core.Token;
import adams.flow.standalone.Rat;
import adams.flow.standalone.rats.PollingRatInput;

public class RatRunnable
extends RunnableWithLogging {
    private static final long serialVersionUID = 143445804089303521L;
    protected Rat m_Owner;
    protected boolean m_HasActors;

    public RatRunnable(Rat owner) {
        this.m_Owner = owner;
        this.m_HasActors = owner.getActorHandler().active() > 0;
    }

    public Rat getOwner() {
        return this.m_Owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWait(int msec) {
        if (msec == 0) {
            return;
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("doWait: " + msec);
        }
        int count = 0;
        while (count < msec && !this.m_Stopped) {
            try {
                int current = msec - 100;
                if (current <= 0) {
                    current = msec;
                }
                if (current > 100) {
                    current = 100;
                }
                RatRunnable ratRunnable = this;
                synchronized (ratRunnable) {
                    ((Object)((Object)this)).wait(current);
                }
                count += current;
            }
            catch (Exception e) {}
        }
    }

    protected String transmit(Object data) {
        String result = null;
        if (data != null) {
            while (!this.m_Owner.getTransmitter().canInput() && !this.m_Stopped) {
                this.doWait(100);
            }
            if (!this.m_Stopped) {
                if (this.isLoggingEnabled()) {
                    this.getLogger().finer("Inputting to " + this.m_Owner.getTransmitter().getFullName());
                }
                this.m_Owner.getTransmitter().input(data);
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("Transmitting to " + this.m_Owner.getTransmitter().getFullName());
                }
                if ((result = this.m_Owner.getTransmitter().transmit()) != null) {
                    this.getLogger().warning("Failed to transmit to " + this.m_Owner.getTransmitter().getFullName() + ": " + result);
                } else if (this.isLoggingEnabled()) {
                    this.getLogger().info("Transmitted to " + this.m_Owner.getTransmitter().getFullName());
                }
            }
        }
        return result;
    }

    protected void doRun() {
        while (!this.m_Stopped) {
            Object data = null;
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Receiving from " + this.m_Owner.getReceiver().getFullName());
            }
            if (this.m_Owner.getReceiver().isStopped()) break;
            String result = this.m_Owner.getReceiver().receive();
            if (result != null) {
                this.getLogger().warning("Failed to receive from " + this.m_Owner.getReceiver().getFullName() + ": " + result);
            } else {
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("Received from " + this.m_Owner.getReceiver().getFullName());
                }
                if (this.isLoggingEnabled()) {
                    this.getLogger().fine("Pending output from " + this.m_Owner.getReceiver().getFullName() + ": " + this.m_Owner.getReceiver().hasPendingOutput());
                }
                while (this.m_Owner.getReceiver().hasPendingOutput() && !this.m_Stopped) {
                    data = this.m_Owner.getReceiver().output();
                    if (this.isLoggingEnabled()) {
                        this.getLogger().finer("Data: " + data);
                    }
                    if (this.m_Stopped) break;
                    if (this.m_HasActors) {
                        if (data == null) continue;
                        this.m_Owner.getActorHandler().input(new Token(data));
                        result = this.m_Owner.getActorHandler().execute();
                        if (result == null) {
                            Token token;
                            while (this.m_Owner.getActorHandler().hasPendingOutput() && !this.m_Stopped && (result = this.transmit((token = this.m_Owner.getActorHandler().output()).getPayload())) == null) {
                            }
                            continue;
                        }
                        this.getLogger().warning("Actors failed to transform data: " + result);
                        continue;
                    }
                    result = this.transmit(data);
                }
            }
            if (this.m_Stopped || !(this.m_Owner.getReceiver() instanceof PollingRatInput)) continue;
            this.doWait(((PollingRatInput)this.m_Owner.getReceiver()).getWaitPoll());
        }
    }
}

