/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.AbstractActor;
import adams.flow.core.Actor;
import adams.flow.core.ActorHandler;
import adams.flow.core.ActorUtils;
import adams.flow.core.ErrorHandler;
import adams.flow.standalone.AbstractStandaloneGroupItem;
import adams.flow.standalone.Rat;
import adams.flow.standalone.rats.generator.AbstractRatGenerator;
import adams.flow.standalone.rats.generator.Dummy;

public class LabRat
extends AbstractStandaloneGroupItem {
    private static final long serialVersionUID = -154461277343021604L;
    protected AbstractRatGenerator m_Generator;

    public String globalInfo() {
        return "Replaces itself at runtime with the actual Rat setup created using the generator.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("generator", "generator", (Object)new Dummy());
    }

    public void setGenerator(AbstractRatGenerator value) {
        this.m_Generator = value;
        this.reset();
    }

    public AbstractRatGenerator getGenerator() {
        return this.m_Generator;
    }

    public String generatorTipText() {
        return "The generator to use.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"generator", (Object)((Object)this.m_Generator), (String)"generator: ");
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            Rat rat = this.m_Generator.generate();
            if (rat.getName().equals(rat.getDefaultName())) {
                rat.setName(this.getName());
            }
            rat.setHeadless(this.isHeadless());
            rat.setVariables(this.getVariables());
            ((ActorHandler)this.getParent()).set(this.index(), (AbstractActor)rat);
            result = rat.setUp();
            if (this.getErrorHandler() != this) {
                ActorUtils.updateErrorHandler((Actor)rat, (ErrorHandler)this.getErrorHandler(), (boolean)this.isLoggingEnabled());
            }
            if (result == null) {
                rat.getOptionManager().updateVariableValues(true);
            }
            this.setParent(null);
            this.cleanUp();
        }
        return result;
    }

    protected String doExecute() {
        return null;
    }
}

