/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.rats.output;

import adams.core.QuickInfoHelper;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.standalone.rats.output.AbstractRatOutput;
import java.io.File;

public class FileMover
extends AbstractRatOutput {
    private static final long serialVersionUID = 5834627889486613248L;
    protected PlaceholderDirectory m_Target;
    protected int m_WaitMove;

    public String globalInfo() {
        return "Moves files into the target directory after a specified time period.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("wait-move", "waitMove", (Object)0, (Number)0, null);
        this.m_OptionManager.add("target", "target", (Object)new PlaceholderDirectory());
    }

    public void setWaitMove(int value) {
        if (value >= 0) {
            this.m_WaitMove = value;
            this.reset();
        } else {
            this.getLogger().warning("Number of milli-seconds to wait must be >=0, provided: " + value);
        }
    }

    public int getWaitMove() {
        return this.m_WaitMove;
    }

    public String waitMoveTipText() {
        return "The number of milli-seconds to wait before moving the files.";
    }

    public void setTarget(PlaceholderDirectory value) {
        this.m_Target = value;
        this.reset();
    }

    public PlaceholderDirectory getTarget() {
        return this.m_Target;
    }

    public String targetTipText() {
        return "The directory to move the files to.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"waitMove", (Object)this.getWaitMove(), (String)"wait-move: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"target", (Object)this.getTarget(), (String)", target: ");
        return result;
    }

    @Override
    public String check() {
        String result = super.check();
        if (result == null && !this.getTarget().exists()) {
            result = "Target directory does not exist: " + this.getTarget();
        }
        if (result == null && !this.getTarget().isDirectory()) {
            result = "Target is not a directory: " + this.getTarget();
        }
        return result;
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String.class, String[].class, File.class, File[].class};
    }

    @Override
    protected String doTransmit() {
        String result = null;
        PlaceholderFile[] files = FileUtils.toPlaceholderFileArray((Object)this.m_Input);
        if (result == null) {
            this.doWait(this.m_WaitMove);
            for (PlaceholderFile file : files) {
                try {
                    boolean ok = FileUtils.move((File)file, (File)this.m_Target);
                    if (!this.isLoggingEnabled()) continue;
                    this.getLogger().fine("Moving " + (ok ? "succeeded" : "failed") + ": " + file + " -> " + this.m_Target);
                }
                catch (Exception e) {
                    result = result == null ? "" : result + "\n";
                    result = result + this.handleException("Failed to move '" + file + "' to '" + this.m_Target + "'!", e);
                }
            }
        }
        return result;
    }
}

