/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.rats.output;

import adams.core.QuickInfoHelper;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import adams.flow.standalone.FTPConnection;
import adams.flow.standalone.rats.output.AbstractRatOutput;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.net.ftp.FTPClient;

public class FtpUpload
extends AbstractRatOutput {
    private static final long serialVersionUID = -641728833085302442L;
    protected String m_RemoteDir;
    protected int m_WaitFTP;
    protected FTPConnection m_Connection;

    public String globalInfo() {
        return "Sends the incoming files to a FTP server.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("wait-ftp", "waitFTP", (Object)0, (Number)0, null);
        this.m_OptionManager.add("remote-dir", "remoteDir", (Object)"/pub");
    }

    public void setWaitFTP(int value) {
        if (value >= 0) {
            this.m_WaitFTP = value;
            this.reset();
        } else {
            this.getLogger().warning("Number of milli-seconds to wait must be >=0, provided: " + value);
        }
    }

    public int getWaitFTP() {
        return this.m_WaitFTP;
    }

    public String waitFTPTipText() {
        return "The number of milli-seconds to wait before FTP-ing the files.";
    }

    public void setRemoteDir(String value) {
        this.m_RemoteDir = value;
        this.reset();
    }

    public String getRemoteDir() {
        return this.m_RemoteDir;
    }

    public String remoteDirTipText() {
        return "The FTP directory to upload the file(s) to.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"waitFTP", (Object)this.getWaitFTP(), (String)"wait-ftp: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"removeDir", (Object)this.getRemoteDir(), (String)", remote dir: ");
        return result;
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String.class, String[].class, File.class, File[].class};
    }

    @Override
    public String check() {
        String result = super.check();
        if (result == null) {
            this.m_Connection = (FTPConnection)ActorUtils.findClosestType((AbstractActor)this.m_Owner, FTPConnection.class);
            if (this.m_Connection == null) {
                result = "No " + FTPConnection.class.getName() + " actor found!";
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String ftp(String filename) {
        String result = null;
        PlaceholderFile file = new PlaceholderFile(filename);
        String remotefile = this.m_RemoteDir + "/" + file.getName();
        FTPClient client = this.m_Connection.getFTPClient();
        BufferedInputStream stream = null;
        try {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Uploading " + file + " to " + remotefile);
            }
            stream = new BufferedInputStream(new FileInputStream(file.getAbsoluteFile()));
            client.storeFile(remotefile, (InputStream)stream);
            stream.close();
        }
        catch (Exception e) {
            result = this.handleException("Failed to ftp '" + file + "' to '" + remotefile + "'!", e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception e) {}
            }
        }
        return result;
    }

    @Override
    protected String doTransmit() {
        String file;
        String result = null;
        String[] files = FileUtils.toStringArray((Object)this.m_Input);
        this.doWait(this.m_WaitFTP);
        String[] arr$ = files;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (result = this.ftp(file = arr$[i$])) == null; ++i$) {
        }
        return result;
    }
}

