/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.rats.generator;

import adams.core.CleanUpHandler;
import adams.core.Destroyable;
import adams.core.io.FileUtils;
import adams.core.option.OptionUtils;
import adams.flow.standalone.rats.generator.AbstractRatGenerator;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.io.File;

public abstract class AbstractRatGeneratorTestCase
extends AdamsTestCase {
    public AbstractRatGeneratorTestCase(String name) {
        super(name);
    }

    protected AbstractTestHelper newTestHelper() {
        return new TestHelper((AdamsTestCase)this, "adams/flow/standalone/rats/generator/data");
    }

    protected abstract AbstractRatGenerator[] getRegressionSetups();

    protected String generate(AbstractRatGenerator scheme) {
        return OptionUtils.getCommandLine((Object)scheme.generate());
    }

    protected boolean save(String data, String filename) {
        return FileUtils.writeToFile((String)(this.m_TestHelper.getTmpDirectory() + File.separator + filename), (Object)data, (boolean)false);
    }

    protected String createOutputFilename(int no) {
        return "out-" + no;
    }

    public void testRegression() {
        int i;
        if (this.m_NoRegressionTest) {
            return;
        }
        AbstractRatGenerator[] setups = this.getRegressionSetups();
        String[] output = new String[setups.length];
        for (i = 0; i < setups.length; ++i) {
            String processed = this.generate(setups[i]).toString();
            AbstractRatGeneratorTestCase.assertNotNull((String)"Failed to generate setups?", (Object)processed);
            output[i] = this.createOutputFilename(i);
            boolean ok = this.save(processed, output[i]);
            AbstractRatGeneratorTestCase.assertTrue((String)"Failed to save regression data?", (boolean)ok);
        }
        TmpFile[] outputFiles = new TmpFile[output.length];
        for (i = 0; i < output.length; ++i) {
            outputFiles[i] = new TmpFile(output[i]);
        }
        String regression = this.m_Regression.compare((File[])outputFiles);
        AbstractRatGeneratorTestCase.assertNull((String)("Output differs:\n" + regression), (Object)regression);
        for (i = 0; i < output.length; ++i) {
            if (setups[i] instanceof Destroyable) {
                setups[i].destroy();
            } else if (setups[i] instanceof CleanUpHandler) {
                ((CleanUpHandler)setups[i]).cleanUp();
            }
            this.m_TestHelper.deleteFileFromTmp(output[i]);
        }
        this.cleanUpAfterRegression();
    }

    protected void cleanUpAfterRegression() {
    }
}

