/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.Pausable;
import adams.core.Properties;
import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.Variables;
import adams.core.base.BaseRegExp;
import adams.core.logging.LoggingLevel;
import adams.core.option.OptionHandler;
import adams.db.LogEntry;
import adams.event.VariableChangeListener;
import adams.flow.container.ErrorContainer;
import adams.flow.control.LocalScopeTransformer;
import adams.flow.control.ScopeHandler;
import adams.flow.control.StorageName;
import adams.flow.core.Actor;
import adams.flow.core.ActorHandlerInfo;
import adams.flow.core.ActorUtils;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.CallableActorReference;
import adams.flow.core.CallableActorUser;
import adams.flow.core.Compatibility;
import adams.flow.core.ErrorHandler;
import adams.flow.core.InputConsumer;
import adams.flow.core.MutableActorHandler;
import adams.flow.core.QueueHelper;
import adams.flow.core.RatState;
import adams.flow.core.Token;
import adams.flow.standalone.AbstractStandaloneGroupItem;
import adams.flow.standalone.RatControl;
import adams.flow.standalone.Rats;
import adams.flow.standalone.rats.RatRunnable;
import adams.flow.standalone.rats.input.DummyInput;
import adams.flow.standalone.rats.input.RatInput;
import adams.flow.standalone.rats.output.DummyOutput;
import adams.flow.standalone.rats.output.RatOutput;
import java.util.Date;
import java.util.HashSet;

public class Rat
extends AbstractStandaloneGroupItem<Rats>
implements MutableActorHandler,
CallableActorUser,
Pausable {
    private static final long serialVersionUID = -154461277343021604L;
    protected RatInput m_Receiver;
    protected LocalScopeTransformer m_Actors;
    protected RatOutput m_Transmitter;
    protected CallableActorReference m_Log;
    protected Actor m_LogActor;
    protected CallableActorHelper m_Helper;
    protected RatRunnable m_Runnable;
    protected StorageName m_FlowErrorQueue;
    protected StorageName m_SendErrorQueue;
    protected boolean m_ShowInControl;
    protected boolean m_Stopping;
    protected boolean m_SuppressErrors;
    protected RatState m_InitialState;

    public String globalInfo() {
        return "Defines a single reception/transmission setup.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("receiver", "receiver", (Object)new DummyInput());
        this.m_OptionManager.add("actor", "actors", (Object)new Actor[0]);
        this.m_OptionManager.add("transmitter", "transmitter", (Object)new DummyOutput());
        this.m_OptionManager.add("log", "log", (Object)new CallableActorReference("unknown"));
        this.m_OptionManager.add("scope-handling-variables", "scopeHandlingVariables", (Object)ScopeHandler.ScopeHandling.EMPTY);
        this.m_OptionManager.add("propagate-variables", "propagateVariables", (Object)false);
        this.m_OptionManager.add("variables-regexp", "variablesRegExp", (Object)new BaseRegExp(".*"));
        this.m_OptionManager.add("scope-handling-storage", "scopeHandlingStorage", (Object)ScopeHandler.ScopeHandling.EMPTY);
        this.m_OptionManager.add("propagate-storage", "propagateStorage", (Object)false);
        this.m_OptionManager.add("storage-regexp", "storageRegExp", (Object)new BaseRegExp(".*"));
        this.m_OptionManager.add("flow-error-queue", "flowErrorQueue", (Object)new StorageName("flowerrors"));
        this.m_OptionManager.add("send-error-queue", "sendErrorQueue", (Object)new StorageName("senderrors"));
        this.m_OptionManager.add("suppress-errors", "suppressErrors", (Object)true);
        this.m_OptionManager.add("show-in-control", "showInControl", (Object)false);
        this.m_OptionManager.add("initial-state", "initialState", (Object)RatState.RUNNING);
    }

    protected void initialize() {
        super.initialize();
        this.m_Actors = new LocalScopeTransformer();
        this.m_Actors.setParent((Actor)this);
        this.m_Helper = new CallableActorHelper();
    }

    public synchronized void setLoggingLevel(LoggingLevel value) {
        super.setLoggingLevel(value);
        this.m_Actors.setLoggingLevel(value);
    }

    public void setReceiver(RatInput value) {
        this.m_Receiver = value;
        this.m_Receiver.setOwner(this);
        this.reset();
    }

    public RatInput getReceiver() {
        return this.m_Receiver;
    }

    public String receiverTipText() {
        return "The receiver to use.";
    }

    public LocalScopeTransformer getActorHandler() {
        return this.m_Actors;
    }

    public void setActors(Actor[] value) {
        this.m_Actors.setActors(value);
        this.reset();
    }

    public Actor[] getActors() {
        return this.m_Actors.getActors();
    }

    public String actorsTipText() {
        return "The actors for transforming the data obtained by the receiver before sending it to the transmitter.";
    }

    public void setTransmitter(RatOutput value) {
        this.m_Transmitter = value;
        this.m_Transmitter.setOwner(this);
        this.reset();
    }

    public RatOutput getTransmitter() {
        return this.m_Transmitter;
    }

    public String transmitterTipText() {
        return "The transmitter to use.";
    }

    public void setLog(CallableActorReference value) {
        this.m_Log = value;
        this.reset();
    }

    public CallableActorReference getLog() {
        return this.m_Log;
    }

    public String logTipText() {
        return "The name of the callable log actor to use (logging disabled if actor not found).";
    }

    public void setScopeHandlingVariables(ScopeHandler.ScopeHandling value) {
        this.m_Actors.setScopeHandlingVariables(value);
        this.reset();
    }

    public ScopeHandler.ScopeHandling getScopeHandlingVariables() {
        return this.m_Actors.getScopeHandlingVariables();
    }

    public String scopeHandlingVariablesTipText() {
        return this.m_Actors.scopeHandlingVariablesTipText();
    }

    public void setPropagateVariables(boolean value) {
        this.m_Actors.setPropagateVariables(value);
        this.reset();
    }

    public boolean getPropagateVariables() {
        return this.m_Actors.getPropagateVariables();
    }

    public String propagateVariablesTipText() {
        return "If enabled, variables that match the specified regular expression get propagated to the outer scope.";
    }

    public void setVariablesRegExp(BaseRegExp value) {
        this.m_Actors.setVariablesRegExp(value);
        this.reset();
    }

    public BaseRegExp getVariablesRegExp() {
        return this.m_Actors.getVariablesRegExp();
    }

    public String variablesRegExpTipText() {
        return "The regular expression that variable names must match in order to get propagated.";
    }

    public void setScopeHandlingStorage(ScopeHandler.ScopeHandling value) {
        this.m_Actors.setScopeHandlingStorage(value);
        this.reset();
    }

    public ScopeHandler.ScopeHandling getScopeHandlingStorage() {
        return this.m_Actors.getScopeHandlingStorage();
    }

    public String scopeHandlingStorageTipText() {
        return this.m_Actors.scopeHandlingStorageTipText();
    }

    public void setPropagateStorage(boolean value) {
        this.m_Actors.setPropagateStorage(value);
        this.reset();
    }

    public boolean getPropagateStorage() {
        return this.m_Actors.getPropagateStorage();
    }

    public String propagateStorageTipText() {
        return "If enabled, storage items which names match the specified regular expression get propagated to the outer scope.";
    }

    public void setStorageRegExp(BaseRegExp value) {
        this.m_Actors.setStorageRegExp(value);
        this.reset();
    }

    public BaseRegExp getStorageRegExp() {
        return this.m_Actors.getStorageRegExp();
    }

    public String storageRegExpTipText() {
        return "The regular expression that the names of storage items must match in order to get propagated.";
    }

    public void setFlowErrorQueue(StorageName value) {
        this.m_FlowErrorQueue = value;
        this.reset();
    }

    public StorageName getFlowErrorQueue() {
        return this.m_FlowErrorQueue;
    }

    public String flowErrorQueueTipText() {
        return "The name of the (optional) queue in internal storage to feed with flow errors; Forwards the original data received as payload in an " + ErrorContainer.class.getName() + " alongside the error message.";
    }

    public void setSendErrorQueue(StorageName value) {
        this.m_SendErrorQueue = value;
        this.reset();
    }

    public StorageName getSendErrorQueue() {
        return this.m_SendErrorQueue;
    }

    public String sendErrorQueueTipText() {
        return "The name of the (optional) queue in internal storage to feed with send errors; Forwards the original data received as payload in an " + ErrorContainer.class.getName() + " alongside the error message.";
    }

    public void setSuppressErrors(boolean value) {
        this.m_SuppressErrors = value;
        this.reset();
    }

    public boolean getSuppressErrors() {
        return this.m_SuppressErrors;
    }

    public String suppressErrorsTipText() {
        return "If enabled, errors are suppressed and only forwarded to the log actor.";
    }

    public void setShowInControl(boolean value) {
        this.m_ShowInControl = value;
        this.reset();
    }

    public boolean getShowInControl() {
        return this.m_ShowInControl;
    }

    public String showInControlTipText() {
        return "If enabled, this Rat will be displayed in the " + RatControl.class.getName() + " control panel.";
    }

    public void setInitialState(RatState value) {
        this.m_InitialState = value;
        this.reset();
    }

    public RatState getInitialState() {
        return this.m_InitialState;
    }

    public String initialStateTipText() {
        return "The initial state of the Rat actor.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"receiver", (Object)this.m_Receiver, (String)"receiver: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"transmitter", (Object)this.m_Transmitter, (String)", transmitter: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"log", (Object)this.m_Log, (String)", log: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"flowErrorQueue", (Object)this.m_FlowErrorQueue, (String)", flow errors: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"sendErrorQueue", (Object)this.m_SendErrorQueue, (String)", send errors: ");
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"showInControl", (boolean)this.m_ShowInControl, (String)"control", (String)", ");
        if (value != null) {
            result = result + value;
        }
        result = result + ", variables [";
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"scopeHandlingVariables", (Object)this.getScopeHandlingVariables(), (String)"scope: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"propagateVariables", (Object)(this.getPropagateVariables() ? "propagate" : "no propagation"), (String)", ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"variablesRegExp", (BaseRegExp)this.getVariablesRegExp(), (String)", regexp: ");
        result = result + "]";
        result = result + ", storage [";
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"scopeHandlingStorage", (Object)this.getScopeHandlingStorage(), (String)"scope: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"propagateStorage", (Object)(this.getPropagateStorage() ? "propagate" : "no propagation"), (String)", ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"storageRegExp", (BaseRegExp)this.getStorageRegExp(), (String)", regexp: ");
        result = result + "]";
        return result;
    }

    public void setParent(Actor value) {
        super.setParent(value);
        this.m_Actors.setParent(null);
        this.m_Actors.setParent(value);
        this.m_Actors.setName(this.getName());
    }

    public ActorHandlerInfo getActorHandlerInfo() {
        return this.m_Actors.getActorHandlerInfo();
    }

    public void setErrorHandler(ErrorHandler value) {
        super.setErrorHandler(value);
        if (this.m_Actors != null) {
            this.m_Actors.setErrorHandler(value);
        }
    }

    public String handleError(Actor source, String type, String msg) {
        if (this.m_LogActor != null) {
            Properties props = new Properties();
            props.setProperty("Message", msg);
            LogEntry entry = new LogEntry();
            entry.setGeneration(new Date());
            entry.setSource(this.getFullName());
            entry.setType(type);
            entry.setStatus("New");
            entry.setMessage(props);
            ((InputConsumer)this.m_LogActor).input(new Token((Object)entry));
            this.m_LogActor.execute();
        }
        source.getLogger().severe(msg);
        if (this.m_StopFlowOnError) {
            this.stopIfNecessary();
        }
        if (this.m_SuppressErrors) {
            return null;
        }
        return msg;
    }

    public String check() {
        return this.m_Actors.check();
    }

    public int size() {
        return this.m_Actors.size();
    }

    public Actor get(int index) {
        return this.m_Actors.get(index);
    }

    public void set(int index, Actor actor) {
        this.m_Actors.set(index, actor);
    }

    public int indexOf(String actor) {
        return this.m_Actors.indexOf(actor);
    }

    public Actor firstActive() {
        return this.m_Actors.firstActive();
    }

    public Actor lastActive() {
        return this.m_Actors.lastActive();
    }

    public void add(Actor actor) {
        this.m_Actors.add(actor);
    }

    public void add(int index, Actor actor) {
        this.m_Actors.add(index, actor);
    }

    public Actor remove(int index) {
        return this.m_Actors.remove(index);
    }

    public void removeAll() {
        this.m_Actors.removeAll();
    }

    public LocalScopeTransformer getLocalScope() {
        return this.m_Actors;
    }

    protected void forceVariables(Variables value) {
        super.forceVariables(value);
        this.m_Actors.setVariables(value);
    }

    protected Actor findCallableActor() {
        return this.m_Helper.findCallableActorRecursive((Actor)this, this.getLog());
    }

    public boolean hasCallableActor() {
        return this.m_LogActor != null;
    }

    public Actor getCallableActor() {
        return this.m_LogActor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(String msg, String id) {
        if (id != null && id.trim().length() == 0) {
            id = null;
        }
        if (this.m_LogActor == null) {
            this.getLogger().severe("LOG: " + (id == null ? "" : id + " - ") + msg);
            return;
        }
        Properties props = new Properties();
        props.setProperty("Errors", msg);
        if (id != null) {
            props.setProperty("ID", id);
        }
        LogEntry log = new LogEntry();
        log.setType("Rat");
        log.setSource(this.getFullName());
        log.setStatus("New");
        log.setMessage(props);
        try {
            String result;
            Actor actor = this.m_LogActor;
            synchronized (actor) {
                ((InputConsumer)this.m_LogActor).input(new Token((Object)log));
                result = this.m_LogActor.execute();
            }
            if (result != null) {
                this.getLogger().severe("Failed to log message:\n" + log + "\n" + result);
            }
        }
        catch (Exception e) {
            this.handleException("Failed to log message:\n" + log, e);
        }
    }

    public boolean queueSendError(Object payload, String error) {
        if (!this.getStorageHandler().getStorage().has(this.m_SendErrorQueue)) {
            return false;
        }
        ErrorContainer cont = new ErrorContainer(payload, error, this.getFullName() + "#send");
        return QueueHelper.enqueue((Actor)this, (StorageName)this.m_SendErrorQueue, (Object)((Object)cont));
    }

    public boolean queueFlowError(Object payload, String error) {
        if (!this.getStorageHandler().getStorage().has(this.m_FlowErrorQueue)) {
            return false;
        }
        ErrorContainer cont = new ErrorContainer(payload, error, this.getFullName() + "#flow");
        return QueueHelper.enqueue((Actor)this, (StorageName)this.m_FlowErrorQueue, (Object)((Object)cont));
    }

    public String setUp() {
        Compatibility comp;
        String result = super.setUp();
        if (result == null) {
            result = this.m_Actors.setUp();
        }
        if (result == null) {
            comp = new Compatibility();
            if (this.m_Actors.active() > 0) {
                if (!comp.isCompatible(new Class[]{this.m_Receiver.generates()}, this.m_Actors.accepts())) {
                    result = "Receiver not compatible with actors: " + Utils.classToString((Class)this.m_Receiver.generates()) + " != " + Utils.classesToString((Class[])this.m_Actors.accepts());
                }
                if (result == null && !comp.isCompatible(this.m_Actors.generates(), this.m_Transmitter.accepts())) {
                    result = "Actors not compatible with transmitter: " + Utils.classesToString((Class[])this.m_Actors.generates()) + " != " + Utils.classesToString((Class[])this.m_Transmitter.accepts());
                }
            } else if (!comp.isCompatible(new Class[]{this.m_Receiver.generates()}, this.m_Transmitter.accepts())) {
                result = "Receiver not compatible with transmitter: " + Utils.classToString((Class)this.m_Receiver.generates()) + " != " + Utils.classesToString((Class[])this.m_Transmitter.accepts());
            }
            if (result == null) {
                result = this.m_Receiver.setUp();
            }
            if (result == null) {
                result = this.m_Transmitter.setUp();
            }
        }
        if (result == null) {
            this.m_LogActor = this.findCallableActor();
            if (this.m_LogActor == null) {
                String msg = "Couldn't find callable log actor '" + this.getLog() + "' - logging disabled!";
                this.getLogger().info(msg);
            } else {
                comp = new Compatibility();
                if (!comp.isCompatible(new Class[]{LogEntry.class}, ((InputConsumer)this.m_LogActor).accepts())) {
                    result = "Log actor '" + this.getLog() + "' must accept " + LogEntry.class.getName() + "!";
                }
                if (result == null) {
                    HashSet variables = this.findVariables(this.m_LogActor);
                    this.m_DetectedVariables.addAll(variables);
                    if (this.m_DetectedVariables.size() > 0) {
                        this.getVariables().addVariableChangeListener((VariableChangeListener)this);
                    }
                }
            }
        }
        if (result == null) {
            ActorUtils.updateErrorHandler((Actor)this, (ErrorHandler)this, (boolean)this.isLoggingEnabled());
            this.m_Actors.setErrorHandler((ErrorHandler)this);
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        try {
            this.m_Receiver.getOptionManager().updateVariableValues(true);
            this.m_Transmitter.getOptionManager().updateVariableValues(true);
            this.m_Runnable = new RatRunnable(this);
            this.m_Runnable.setLoggingLevel(this.getLoggingLevel());
            switch (this.m_InitialState) {
                case RUNNING: {
                    break;
                }
                case PAUSED: {
                    if (this.isLoggingEnabled()) {
                        this.getLogger().info("Starting rat in paused mode");
                    }
                    this.m_Runnable.pauseExecution();
                    break;
                }
                default: {
                    result = "Unhandled initial rat state: " + (Object)((Object)this.m_InitialState);
                }
            }
            if (result == null) {
                new Thread((Runnable)((Object)this.m_Runnable)).start();
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to execute!", e);
        }
        return result;
    }

    public void pauseExecution() {
        if (this.m_Runnable != null) {
            this.m_Runnable.pauseExecution();
        }
    }

    public boolean isPaused() {
        return this.m_Runnable != null && this.m_Runnable.isPaused();
    }

    public void resumeExecution() {
        if (this.m_Runnable != null) {
            this.m_Runnable.resumeExecution();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void stopIfNecessary() {
        if (this.m_Stopping) {
            return;
        }
        if (!this.m_Stopped) {
            this.m_Stopping = true;
            this.m_Actors.stopExecution();
            if (this.m_Runnable != null) {
                this.m_Runnable.stopExecution();
                while (this.m_Runnable.isRunning()) {
                    try {
                        Rat rat = this;
                        synchronized (rat) {
                            ((Object)((Object)this)).wait(10L);
                        }
                    }
                    catch (Exception exception) {
                    }
                }
                this.m_Runnable = null;
            }
            this.m_Stopping = false;
        }
    }

    public void flushExecution() {
        if (this.m_Actors != null) {
            this.m_Actors.flushExecution();
        }
    }

    public void stopExecution() {
        this.stopIfNecessary();
        super.stopExecution();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wrapUp() {
        if (this.m_Runnable != null) {
            this.stopIfNecessary();
        }
        this.m_Actors.wrapUp();
        if (this.m_LogActor != null) {
            Actor actor = this.m_LogActor;
            synchronized (actor) {
                this.m_LogActor.wrapUp();
            }
        }
        super.wrapUp();
    }

    public void cleanUp() {
        this.m_Actors.cleanUp();
        if (this.m_LogActor != null) {
            this.m_LogActor.cleanUp();
            this.m_LogActor = null;
        }
        super.cleanUp();
    }
}

