/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.control.StorageName;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.core.ErrorHandler;
import adams.flow.core.MutableActorHandler;
import adams.flow.standalone.Rat;
import adams.flow.standalone.rats.input.DeQueue;
import adams.flow.standalone.rats.input.DummyInput;
import adams.flow.standalone.rats.output.DummyOutput;
import adams.flow.standalone.rats.output.EnQueue;
import java.util.ArrayList;
import java.util.Iterator;

public class RatPlague
extends Rat {
    private static final long serialVersionUID = -154461277343021604L;
    protected StorageName[] m_Input;
    protected boolean m_HasOutput;
    protected StorageName m_Output;
    protected boolean m_RatsConfigured;

    @Override
    public String globalInfo() {
        return "Replaces itself at runtime with a copy of itself, as many times as there are input queues.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.removeByProperty("receiver");
        this.m_OptionManager.removeByProperty("transmitter");
        this.m_OptionManager.add("input", "input", (Object)new StorageName[0]);
        this.m_OptionManager.add("has-output", "hasOutput", (Object)true);
        this.m_OptionManager.add("output", "output", (Object)new StorageName("queue"));
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.setReceiver(new DummyInput());
        this.setTransmitter(new DummyOutput());
    }

    public void setInput(StorageName[] value) {
        this.m_Input = value;
        this.reset();
    }

    public StorageName[] getInput() {
        return this.m_Input;
    }

    public String inputTipText() {
        return "The names of the input queues in the internal storage.";
    }

    public void setHasOutput(boolean value) {
        this.m_HasOutput = value;
        this.reset();
    }

    public boolean getHasOutput() {
        return this.m_HasOutput;
    }

    public String hasOutputTipText() {
        return "If enabled, an output queue is configured.";
    }

    public void setOutput(StorageName value) {
        this.m_Output = value;
        this.reset();
    }

    public StorageName getOutput() {
        return this.m_Output;
    }

    public String outputTipText() {
        return "The name of the output queue in the internal storage.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"input", (Object)this.m_Input, (String)"input: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"output", (Object)(this.m_HasOutput ? this.m_Output : "-none-"), (String)", output: ");
        return result;
    }

    protected String setUpRats(boolean execute) {
        String result = null;
        int index = this.index();
        MutableActorHandler parent = (MutableActorHandler)this.getParent();
        ArrayList<Rat> rats = new ArrayList<Rat>();
        for (int i = 0; i < this.m_Input.length; ++i) {
            Rat rat = new Rat();
            rat.setName(this.getName() + "-" + this.m_Input[i].getValue());
            DeQueue dequeue = new DeQueue();
            dequeue.setStorageName(this.m_Input[i]);
            rat.setReceiver(dequeue);
            if (this.m_HasOutput) {
                EnQueue enqueue = new EnQueue();
                enqueue.setStorageName(this.m_Output);
                rat.setTransmitter(enqueue);
            } else {
                rat.setTransmitter(new DummyOutput());
            }
            rat.setLog(this.getLog());
            rat.setScopeHandlingVariables(this.getScopeHandlingVariables());
            rat.setPropagateVariables(this.getPropagateVariables());
            rat.setVariablesRegExp(this.getVariablesRegExp());
            rat.setScopeHandlingStorage(this.getScopeHandlingStorage());
            rat.setPropagateStorage(this.getPropagateStorage());
            rat.setStorageRegExp(this.getStorageRegExp());
            rat.setSendErrorQueue(this.getSendErrorQueue());
            rat.setShowInControl(this.getShowInControl());
            rat.removeAll();
            for (int n = 0; n < this.size(); ++n) {
                rat.add(this.get(n).shallowCopy());
            }
            rat.setVariables(this.getVariables());
            if (i == 0) {
                parent.set(index, (Actor)rat);
            } else {
                parent.add(index + i, (Actor)rat);
            }
            rats.add(rat);
            result = rat.setUp();
            if (this.getErrorHandler() != this) {
                ActorUtils.updateErrorHandler((Actor)rat, (ErrorHandler)this.getErrorHandler(), (boolean)this.isLoggingEnabled());
            }
            if (result != null) break;
            rat.getOptionManager().updateVariableValues(true);
        }
        this.setParent(null);
        this.cleanUp();
        if (result == null && execute) {
            Rat r;
            Iterator iterator = rats.iterator();
            while (iterator.hasNext() && (result = (r = (Rat)((Object)iterator.next())).execute()) == null) {
            }
        }
        this.m_RatsConfigured = true;
        return result;
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        this.m_RatsConfigured = false;
        boolean canSetUp = false;
        if (result == null && !this.getOptionManager().hasVariableForProperty("input")) {
            canSetUp = true;
            if (this.m_Input.length == 0) {
                result = "No input queues defined!";
            }
        }
        if (result == null && !(this.getParent() instanceof MutableActorHandler)) {
            result = "Parent is not a " + MutableActorHandler.class.getName() + "!";
        }
        if (result == null && canSetUp) {
            result = this.setUpRats(false);
        }
        return result;
    }

    @Override
    protected String doExecute() {
        String result = null;
        if (!this.m_RatsConfigured) {
            result = this.setUpRats(true);
        }
        return result;
    }
}

