/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.rats;

import adams.core.StoppableWithFeedback;
import adams.core.Utils;
import adams.core.logging.LoggingObject;
import adams.flow.core.RunnableWithLogging;
import adams.flow.core.Token;
import adams.flow.standalone.Rat;
import adams.flow.standalone.rats.input.PollingRatInput;

public class RatRunnable
extends RunnableWithLogging {
    private static final long serialVersionUID = 143445804089303521L;
    protected Rat m_Owner;
    protected boolean m_HasActors;
    protected boolean m_Paused;

    public RatRunnable(Rat owner) {
        this.m_Owner = owner;
        this.m_HasActors = owner.getActorHandler().active() > 0;
        this.m_Paused = false;
    }

    public Rat getOwner() {
        return this.m_Owner;
    }

    protected String transmit(Object data) {
        String result = null;
        if (data != null) {
            while (!this.m_Owner.getTransmitter().canInput() && !this.m_Stopped) {
                Utils.wait((LoggingObject)this, (StoppableWithFeedback)this, (int)100, (int)100);
            }
            if (!this.m_Stopped) {
                if (this.isLoggingEnabled()) {
                    this.getLogger().finer("Inputting to " + this.m_Owner.getTransmitter().getFullName());
                }
                this.m_Owner.getTransmitter().input(data);
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("Transmitting to " + this.m_Owner.getTransmitter().getFullName());
                }
                if ((result = this.m_Owner.getTransmitter().transmit()) != null) {
                    this.getLogger().warning("Failed to transmit to " + this.m_Owner.getTransmitter().getFullName() + ": " + result);
                } else if (this.isLoggingEnabled()) {
                    this.getLogger().info("Transmitted to " + this.m_Owner.getTransmitter().getFullName());
                }
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doRun() {
        while (!this.m_Stopped) {
            String result;
            while (this.m_Paused && !this.m_Stopped) {
                Utils.wait((LoggingObject)this, (StoppableWithFeedback)this, (int)100, (int)10);
            }
            Object data = null;
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Receiving from " + this.m_Owner.getReceiver().getFullName());
            }
            if (this.m_Owner.getReceiver().isStopped()) break;
            try {
                result = this.m_Owner.getReceiver().receive();
            }
            catch (Throwable t) {
                result = Utils.throwableToString((Throwable)t);
            }
            if (this.m_Stopped) break;
            if (result != null) {
                this.getOwner().log("Failed to receive from " + this.m_Owner.getReceiver().getFullName() + ": " + result, "receive");
            } else {
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("Received from " + this.m_Owner.getReceiver().getFullName());
                }
                if (this.isLoggingEnabled()) {
                    this.getLogger().fine("Pending output from " + this.m_Owner.getReceiver().getFullName() + ": " + this.m_Owner.getReceiver().hasPendingOutput());
                }
                try {
                    block10: while (this.m_Owner.getReceiver().hasPendingOutput() && !this.m_Stopped) {
                        data = this.m_Owner.getReceiver().output();
                        if (this.isLoggingEnabled()) {
                            this.getLogger().finer("Data: " + data);
                        }
                        if (this.m_Stopped) break;
                        if (this.m_HasActors) {
                            if (data == null) continue;
                            this.m_Owner.getActorHandler().input(new Token(data));
                            result = this.m_Owner.getActorHandler().execute();
                            if (result != null) {
                                this.getOwner().queueFlowError(data, result);
                                continue;
                            }
                        } else {
                            try {
                                result = this.transmit(data);
                            }
                            catch (Throwable t) {
                                result = Utils.throwableToString((Throwable)t);
                            }
                            if (result == null) continue;
                            this.getOwner().queueSendError(data, result);
                            continue;
                        }
                        while (this.m_Owner.getActorHandler().hasPendingOutput() && !this.m_Stopped) {
                            Token token = this.m_Owner.getActorHandler().output();
                            try {
                                result = this.transmit(token.getPayload());
                            }
                            catch (Throwable t) {
                                result = Utils.throwableToString((Throwable)t);
                            }
                            if (result == null) continue;
                            this.getOwner().queueSendError(data, result);
                            continue block10;
                        }
                    }
                }
                catch (Throwable t) {
                    result = Utils.throwableToString((Throwable)t);
                    this.getOwner().queueFlowError(data, result);
                }
                if (result != null) {
                    if (this.m_HasActors) {
                        this.getOwner().log("Actors failed to transform/transmit data: " + result, "transform/transmit");
                    } else {
                        this.getOwner().log("Failed to transmit data: " + result, "transmit");
                    }
                }
            }
            if (this.m_Stopped || !(this.m_Owner.getReceiver() instanceof PollingRatInput)) continue;
            Utils.wait((LoggingObject)this, (StoppableWithFeedback)this, (int)((PollingRatInput)this.m_Owner.getReceiver()).getWaitPoll(), (int)10);
        }
        if (this.m_Stopped) {
            this.m_Owner.getReceiver().stopExecution();
            this.m_Owner.getTransmitter().stopExecution();
        }
    }

    public void pauseExecution() {
        this.m_Paused = true;
    }

    public void resumeExecution() {
        this.m_Paused = false;
    }

    public boolean isPaused() {
        return this.m_Paused;
    }

    public void stopExecution() {
        super.stopExecution();
        this.m_Owner.getReceiver().stopExecution();
        this.m_Owner.getTransmitter().stopExecution();
    }
}

