/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.rats.input;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.control.StorageName;
import adams.flow.control.StorageQueueHandler;
import adams.flow.control.StorageUpdater;
import adams.flow.core.Unknown;
import adams.flow.standalone.rats.input.AbstractRatInput;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class DeQueue
extends AbstractRatInput
implements StorageUpdater {
    private static final long serialVersionUID = 6942772195383207110L;
    protected StorageName m_StorageName;
    protected Object m_Output;
    protected int m_PollTimeout;
    protected transient StorageQueueHandler m_Queue;

    public String globalInfo() {
        return "Polls the specified queue in internal storage for an item, blocks till an item is available.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("storage-name", "storageName", (Object)new StorageName("queue"));
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Output = null;
        this.m_PollTimeout = 100;
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
        this.reset();
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public String storageNameTipText() {
        return "The name of the queue in the internal storage.";
    }

    public boolean isUpdatingStorage() {
        return true;
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"storageName", (Object)this.m_StorageName, (String)"storage: ");
    }

    @Override
    public Class generates() {
        return Unknown.class;
    }

    protected Object poll(StorageQueueHandler queue) {
        Object result = null;
        while (!this.m_Stopped && result == null) {
            try {
                result = queue.poll((long)this.m_PollTimeout, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                if (!this.isLoggingEnabled()) continue;
                this.getLogger().log(Level.INFO, "Exception while polling", (Throwable)e);
            }
        }
        return result;
    }

    @Override
    protected String doReceive() {
        String result = null;
        this.m_Output = null;
        this.m_Queue = this.getQueue(this.m_StorageName);
        if (this.m_Queue == null) {
            result = "Queue not available: " + this.m_StorageName;
        }
        if (result == null) {
            this.m_Output = this.poll(this.m_Queue);
        }
        return result;
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_Output != null;
    }

    @Override
    public Object output() {
        Object result = this.m_Output;
        this.m_Output = null;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopExecution() {
        super.stopExecution();
        if (this.m_Queue != null) {
            StorageQueueHandler storageQueueHandler = this.m_Queue;
            synchronized (storageQueueHandler) {
                this.m_Queue.notifyAll();
            }
        }
    }
}

