/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.rats.input;

import adams.core.Placeholders;
import adams.core.QuickInfoHelper;
import adams.core.management.ProcessUtils;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.flow.standalone.rats.input.AbstractRatInput;

public class Exec
extends AbstractRatInput {
    private static final long serialVersionUID = -2551580796290694417L;
    protected String m_Command;
    protected boolean m_CommandContainsPlaceholder;
    protected boolean m_CommandContainsVariable;
    protected boolean m_OutputStdErr;
    protected String m_Output;

    public String globalInfo() {
        return "Executes a command and forwards either output from stdout or stderr.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("cmd", "command", (Object)"ls -l .");
        this.m_OptionManager.add("placeholder", "commandContainsPlaceholder", (Object)false);
        this.m_OptionManager.add("variable", "commandContainsVariable", (Object)false);
        this.m_OptionManager.add("stderr", "outputStdErr", (Object)false);
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"command", (Object)this.m_Command);
    }

    public void setCommand(String value) {
        this.m_Command = value;
        this.reset();
    }

    public String getCommand() {
        return this.m_Command;
    }

    public String commandTipText() {
        return "The external command to run.";
    }

    public void setCommandContainsPlaceholder(boolean value) {
        this.m_CommandContainsPlaceholder = value;
        this.reset();
    }

    public boolean getCommandContainsPlaceholder() {
        return this.m_CommandContainsPlaceholder;
    }

    public String commandContainsPlaceholderTipText() {
        return "Set this to true to enable automatic placeholder expansion for the command string.";
    }

    public void setCommandContainsVariable(boolean value) {
        this.m_CommandContainsVariable = value;
        this.reset();
    }

    public boolean getCommandContainsVariable() {
        return this.m_CommandContainsVariable;
    }

    public String commandContainsVariableTipText() {
        return "Set this to true to enable automatic variable expansion for the command string.";
    }

    public void setOutputStdErr(boolean value) {
        this.m_OutputStdErr = value;
        this.reset();
    }

    public boolean getOutputStdErr() {
        return this.m_OutputStdErr;
    }

    public String outputStdErrTipText() {
        return "If set to true, then stderr is output instead of stdout.";
    }

    @Override
    protected String doReceive() {
        String result = null;
        String cmd = this.m_Command;
        if (this.m_CommandContainsVariable) {
            cmd = this.getOwner().getVariables().expand(cmd);
        }
        if (this.m_CommandContainsPlaceholder) {
            cmd = Placeholders.getSingleton().expand(cmd).replace("\\", "/");
        }
        try {
            ProcessUtils.ProcessResult proc = ProcessUtils.execute((String[])OptionUtils.splitOptions((String)cmd));
            if (!proc.hasSucceeded()) {
                result = proc.toErrorOutput();
            } else {
                this.m_Output = this.m_OutputStdErr ? proc.getStdErr() : proc.getStdOut();
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to execute command: " + cmd, e);
        }
        return result;
    }

    @Override
    public Class generates() {
        return String.class;
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_Output != null;
    }

    @Override
    public Object output() {
        String result = this.m_Output;
        this.m_Output = null;
        return result;
    }
}

