/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.rats.input;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.CallableActorReference;
import adams.flow.core.CallableActorUser;
import adams.flow.core.InputConsumer;
import adams.flow.core.OutputProducer;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.standalone.rats.input.AbstractMetaRatInput;
import java.util.ArrayList;

public class InputWithCallableTransformer
extends AbstractMetaRatInput
implements CallableActorUser {
    private static final long serialVersionUID = 2063802342977621560L;
    protected CallableActorReference m_CallableName;
    protected Actor m_CallableActor;
    protected CallableActorHelper m_Helper;

    public String globalInfo() {
        return "Meta-receiver that passes the received data through a callable transformer before passing it on.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("callable", "callableName", (Object)new CallableActorReference("unknown"));
    }

    protected void reset() {
        super.reset();
        this.m_CallableActor = null;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Helper = new CallableActorHelper();
    }

    public void setCallableName(CallableActorReference value) {
        this.m_CallableName = value;
        this.reset();
    }

    public CallableActorReference getCallableName() {
        return this.m_CallableName;
    }

    public String callableNameTipText() {
        return "The name of the callable transformer to use.";
    }

    public Actor getCallableActor() {
        return this.m_CallableActor;
    }

    protected Actor findCallableActor() {
        Actor result = this.m_Helper.findCallableActorRecursive((Actor)this.getOwner(), this.getCallableName());
        if (!ActorUtils.isTransformer((Actor)result)) {
            this.getLogger().severe("Callable actor '" + result.getFullName() + "' is not a transformer" + (this.m_CallableActor == null ? "!" : this.m_CallableActor.getClass().getName()));
            result = null;
        }
        return result;
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"callableName", (Object)this.m_CallableName);
    }

    @Override
    public Class generates() {
        Class[] output;
        if (this.m_CallableActor != null && (output = ((OutputProducer)this.m_CallableActor).generates()).length == 1) {
            return output[0];
        }
        return Unknown.class;
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_CallableActor = this.findCallableActor();
            if (this.m_CallableActor == null) {
                result = "Failed to locate callable transformer '" + this.m_CallableName + "', check log!";
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String postReceive() {
        String result = super.postReceive();
        if (result == null && !this.m_CallableActor.getSkip() && !this.m_CallableActor.isStopped()) {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Passing data through '" + this.m_CallableName + "'");
            }
            ArrayList<Object> data = new ArrayList<Object>();
            for (Object obj : this.m_Data) {
                Token input = new Token(obj);
                Actor actor = this.m_CallableActor;
                synchronized (actor) {
                    ((InputConsumer)this.m_CallableActor).input(input);
                    result = this.m_CallableActor.execute();
                    if (result != null) {
                        break;
                    }
                    while (((OutputProducer)this.m_CallableActor).hasPendingOutput()) {
                        Token output = ((OutputProducer)this.m_CallableActor).output();
                        if (output.getPayload() == null) continue;
                        data.add(output.getPayload());
                    }
                }
                if (result != null) continue;
                this.m_Data = data;
            }
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Passed data through '" + this.m_CallableName + "'");
            }
        }
        return result;
    }
}

