/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.rats.output;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.control.StorageName;
import adams.flow.control.StorageQueueHandler;
import adams.flow.control.StorageUpdater;
import adams.flow.core.Unknown;
import adams.flow.standalone.rats.output.AbstractRatOutput;

public class DistributedEnQueue
extends AbstractRatOutput
implements StorageUpdater {
    private static final long serialVersionUID = -148085385347072239L;
    protected StorageName[] m_StorageNames;
    protected int m_NextQueue;

    public String globalInfo() {
        return "Distributes the incoming data in the specified queues in internal storage, iterating through the different queues.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("storage-name", "storageNames", (Object)new StorageName[0]);
    }

    protected void reset() {
        super.reset();
        this.m_NextQueue = 0;
    }

    public void setStorageNames(StorageName[] value) {
        this.m_StorageNames = value;
        this.reset();
    }

    public StorageName[] getStorageNames() {
        return this.m_StorageNames;
    }

    public String storageNamesTipText() {
        return "The names of the queues in the internal storage.";
    }

    public boolean isUpdatingStorage() {
        return true;
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"storageNames", (Object)this.m_StorageNames, (String)"storage: ");
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null && !this.getOptionManager().hasVariableForProperty("storageNames") && this.m_StorageNames.length < 1) {
            result = "At least one queue must be defined!";
        }
        return result;
    }

    @Override
    protected String doTransmit() {
        String result = null;
        if (this.m_StorageNames.length < 1) {
            result = "At least one queue must be defined!";
        }
        if (result == null) {
            StorageQueueHandler queue = this.getQueue(this.m_StorageNames[this.m_NextQueue]);
            if (queue == null) {
                result = "Queue not available: " + this.m_StorageNames[this.m_NextQueue];
            } else {
                queue.add(this.m_Input);
            }
            ++this.m_NextQueue;
            if (this.m_NextQueue >= this.m_StorageNames.length) {
                this.m_NextQueue = 0;
            }
        }
        return result;
    }
}

