/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.rats.output;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.control.StorageName;
import adams.flow.control.StorageQueueHandler;
import adams.flow.control.StorageUpdater;
import adams.flow.core.Unknown;
import adams.flow.standalone.rats.output.AbstractRatOutput;
import adams.flow.standalone.rats.output.enqueue.AbstractEnqueueGuard;
import adams.flow.standalone.rats.output.enqueue.PassThrough;

public class EnQueue
extends AbstractRatOutput
implements StorageUpdater {
    private static final long serialVersionUID = -148085385347072239L;
    protected StorageName m_StorageName;
    protected AbstractEnqueueGuard m_Guard;

    public String globalInfo() {
        return "Enqueues the incoming data in the specified queue in internal storage.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("storage-name", "storageName", (Object)new StorageName("queue"));
        this.m_OptionManager.add("guard", "guard", (Object)new PassThrough());
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
        this.reset();
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public String storageNameTipText() {
        return "The name of the queue in the internal storage.";
    }

    public void setGuard(AbstractEnqueueGuard value) {
        this.m_Guard = value;
        this.reset();
    }

    public AbstractEnqueueGuard getGuard() {
        return this.m_Guard;
    }

    public String guardTipText() {
        return "The guard for enqueuing the data.";
    }

    public boolean isUpdatingStorage() {
        return true;
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"storageName", (Object)this.m_StorageName, (String)"storage: ");
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    protected String doTransmit() {
        String result = null;
        StorageQueueHandler queue = this.getQueue(this.m_StorageName);
        if (queue == null) {
            result = "Queue not available: " + this.m_StorageName;
        } else {
            this.m_Guard.enqueue(queue, this.m_Input);
        }
        return result;
    }

    @Override
    public void stopExecution() {
        this.m_Guard.stopExecution();
        super.stopExecution();
    }
}

