/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.webservice.blob;

import adams.core.option.AbstractOptionHandler;
import adams.data.blob.BlobContainer;
import adams.db.AbstractDatabaseConnection;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.core.RatsBlobHelper;
import adams.flow.standalone.DatabaseConnection;
import adams.flow.standalone.rats.input.BufferedRatInput;
import adams.flow.webservice.blob.OwnedByRatsBlobServiceWS;
import adams.flow.webservice.blob.RatsBlobServiceWS;
import nz.ac.waikato.adams.webservice.rats.blob.RatsBlobService;
import nz.ac.waikato.adams.webservice.rats.blob.UploadRequest;
import nz.ac.waikato.adams.webservice.rats.blob.UploadResponse;

public class SimpleRatsBlobService
extends AbstractOptionHandler
implements RatsBlobService,
OwnedByRatsBlobServiceWS {
    private static final long serialVersionUID = -6102580694812360595L;
    protected RatsBlobServiceWS m_Owner;
    protected AbstractDatabaseConnection m_DatabaseConnection;

    public SimpleRatsBlobService() {
        this.setOwner(null);
    }

    public String globalInfo() {
        return "Simple implementation of a RATS spectrum webservice.";
    }

    protected AbstractDatabaseConnection getDatabaseConnection() {
        return ActorUtils.getDatabaseConnection((Actor)this.m_Owner.getOwner(), DatabaseConnection.class, (AbstractDatabaseConnection)adams.db.DatabaseConnection.getSingleton());
    }

    @Override
    public void setOwner(RatsBlobServiceWS value) {
        this.m_Owner = value;
        this.m_DatabaseConnection = this.m_Owner != null && this.m_Owner.getOwner() != null ? this.getDatabaseConnection() : null;
    }

    @Override
    public RatsBlobServiceWS getOwner() {
        return this.m_Owner;
    }

    @Override
    public UploadResponse upload(UploadRequest parameters) {
        this.m_Owner.getLogger().info("upload: " + parameters.getFilename() + "/" + parameters.getFormat());
        UploadResponse result = new UploadResponse();
        result.setFilename(parameters.getFilename());
        result.setFormat(parameters.getFormat());
        result.setSuccess(true);
        BlobContainer cont = RatsBlobHelper.webserviceToContainer(parameters.getBlob());
        cont.setID(parameters.getFilename());
        if (this.isLoggingEnabled()) {
            this.getLogger().fine(cont.toString());
        }
        if (this.getOwner().getRatInput() instanceof BufferedRatInput) {
            ((BufferedRatInput)this.getOwner().getRatInput()).bufferData(cont);
        }
        return result;
    }
}

