/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Actor;
import adams.flow.core.ControlActor;
import adams.flow.core.RatHelper;
import adams.flow.core.RatReference;
import adams.flow.core.RatState;
import adams.flow.core.Unknown;
import adams.flow.standalone.Rat;
import adams.flow.transformer.AbstractTransformer;

public class ChangeRatState
extends AbstractTransformer
implements ControlActor {
    private static final long serialVersionUID = 7078570350728159543L;
    protected RatReference[] m_Rats;
    protected RatState m_State;
    protected RatHelper m_RatHelper;

    public String globalInfo() {
        return "Changes the state of the specified Rat actors when a token passes through.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("rat", "rats", (Object)new RatReference[0]);
        this.m_OptionManager.add("state", "state", (Object)RatState.PAUSED);
    }

    protected void initialize() {
        super.initialize();
        this.m_RatHelper = new RatHelper();
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"state", (Object)((Object)this.m_State), (String)"new state: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"rats", (Object)this.m_Rats, (String)", rats: ");
        return result;
    }

    public void setRats(RatReference[] value) {
        this.m_Rats = value;
        this.reset();
    }

    public RatReference[] getRats() {
        return this.m_Rats;
    }

    public String ratsTipText() {
        return "The Rat actors to change the state for.";
    }

    public void setState(RatState value) {
        this.m_State = value;
        this.reset();
    }

    public RatState getState() {
        return this.m_State;
    }

    public String stateTipText() {
        return "The new state for the Rat actors.";
    }

    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    public Class[] generates() {
        return new Class[]{Unknown.class};
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            if (this.m_Rats.length == 0) {
                result = "No Rat actor references defined!";
            } else {
                for (int i = 0; i < this.m_Rats.length; ++i) {
                    Actor rat = this.m_RatHelper.findRatRecursive((Actor)this, this.m_Rats[i]);
                    if (rat == null) {
                        result = "Failed to locate Rat #" + (i + 1) + ": " + (Object)((Object)this.m_Rats[i]);
                        break;
                    }
                    if (rat instanceof Rat) continue;
                    result = "Rat #" + (i + 1) + " '" + (Object)((Object)this.m_Rats[i]) + "' is not of type " + Rat.class.getName();
                    break;
                }
            }
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        for (int i = 0; i < this.m_Rats.length; ++i) {
            Actor rat = this.m_RatHelper.findRatRecursive((Actor)this, this.m_Rats[i]);
            if (rat == null) {
                result = "Failed to locate Rat #" + (i + 1) + ": " + (Object)((Object)this.m_Rats[i]);
            } else {
                switch (this.m_State) {
                    case PAUSED: {
                        if (rat instanceof Rat) {
                            ((Rat)rat).pauseExecution();
                            break;
                        }
                        result = "Unhandled actor: " + rat.getClass().getName();
                        break;
                    }
                    case RUNNING: {
                        if (rat instanceof Rat) {
                            ((Rat)rat).resumeExecution();
                            break;
                        }
                        result = "Unhandled actor: " + rat.getClass().getName();
                        break;
                    }
                    default: {
                        result = "Unhandled state: " + (Object)((Object)this.m_State);
                    }
                }
                if (result == null && this.isLoggingEnabled()) {
                    this.getLogger().info("New state set for Rat #" + (i + 1) + " '" + (Object)((Object)this.m_Rats[i]) + "': " + (Object)((Object)this.m_State));
                }
            }
            if (result != null) break;
        }
        if (result == null) {
            this.m_OutputToken = this.m_InputToken;
        }
        return result;
    }
}

