/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.rats.output;

import adams.core.QuickInfoHelper;
import adams.core.VariablesInspectionHandler;
import adams.core.option.OptionHandler;
import adams.core.option.OptionTraverser;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.core.ActorVariablesFinder;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.CallableActorReference;
import adams.flow.core.CallableActorUser;
import adams.flow.core.InputConsumer;
import adams.flow.core.OptionalCallableActor;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.standalone.rats.output.AbstractRatOutput;
import java.util.HashSet;

public class CallableActor
extends AbstractRatOutput
implements CallableActorUser,
OptionalCallableActor {
    private static final long serialVersionUID = 5871927859523743161L;
    protected CallableActorReference m_CallableName;
    protected Actor m_CallableActor;
    protected boolean m_Configured;
    protected CallableActorHelper m_Helper;
    protected boolean m_Optional;

    public String globalInfo() {
        return "Forwards the data to the specified callable actor.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("callable", "callableName", (Object)new CallableActorReference("unknown"));
        this.m_OptionManager.add("optional", "optional", (Object)false);
    }

    protected void reset() {
        super.reset();
        this.m_CallableActor = null;
        this.m_Configured = false;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Helper = new CallableActorHelper();
    }

    public void setCallableName(CallableActorReference value) {
        this.m_CallableName = value;
        this.reset();
    }

    public CallableActorReference getCallableName() {
        return this.m_CallableName;
    }

    public String callableNameTipText() {
        return "The name of the callable actor to use.";
    }

    public void setOptional(boolean value) {
        this.m_Optional = value;
        this.reset();
    }

    public boolean getOptional() {
        return this.m_Optional;
    }

    public String optionalTipText() {
        return "If enabled, then the callable actor is optional, ie no error is raised if not found, merely ignored.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"callableName", (Object)this.m_CallableName);
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"optional", (boolean)this.m_Optional, (String)"optional", (String)", ");
        return result;
    }

    protected Actor findCallableActor() {
        Actor result = this.m_Helper.findCallableActorRecursive((Actor)this.m_Owner, this.getCallableName());
        if (result != null && !ActorUtils.isSink((Actor)result)) {
            this.getLogger().severe("Callable actor '" + result.getFullName() + "' is not a sink" + (this.m_CallableActor == null ? "!" : this.m_CallableActor.getClass().getName()));
            result = null;
        }
        return result;
    }

    public boolean hasCallableActor() {
        return this.m_CallableActor != null;
    }

    public Actor getCallableActor() {
        return this.m_CallableActor;
    }

    protected HashSet<String> findVariables(Actor actor) {
        this.getLogger().finest("Locating variables in " + actor.getFullName() + "...");
        ActorVariablesFinder finder = new ActorVariablesFinder();
        finder.setInspection((VariablesInspectionHandler)actor);
        actor.getOptionManager().traverse((OptionTraverser)finder);
        HashSet result = finder.getResult();
        this.getLogger().finest("Found variables in " + actor.getFullName() + " (" + result.size() + "): " + result);
        return result;
    }

    protected String setUpCallableActor() {
        String result = null;
        this.m_CallableActor = this.findCallableActor();
        this.m_Configured = true;
        if (this.m_CallableActor == null) {
            if (!this.m_Optional) {
                result = "Couldn't find callable actor '" + this.getCallableName() + "'!";
            } else {
                this.getLogger().info("Callable actor '" + this.getCallableName() + "' not found, ignoring.");
            }
        }
        return result;
    }

    @Override
    public Class[] accepts() {
        if (this.m_CallableActor != null) {
            return ((InputConsumer)this.m_CallableActor).accepts();
        }
        return new Class[]{Unknown.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doTransmit() {
        String result = null;
        if (!this.m_Configured) {
            result = this.setUpCallableActor();
        }
        if (result == null) {
            Actor actor = this.m_CallableActor;
            synchronized (actor) {
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("Executing callable actor - start: " + this.m_CallableActor);
                }
                ((InputConsumer)this.m_CallableActor).input(new Token(this.m_Input));
                result = this.m_CallableActor.execute();
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("Executing callable actor - end: " + result);
                }
            }
        }
        return result;
    }
}

