/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.rats.output;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.flow.control.StorageName;
import adams.flow.control.StorageQueueHandler;
import adams.flow.control.StorageUpdater;
import adams.flow.core.Unknown;
import adams.flow.standalone.rats.output.AbstractRatOutput;

public class QueueDistribute
extends AbstractRatOutput
implements StorageUpdater {
    private static final long serialVersionUID = -148085385347072239L;
    protected StorageName[] m_StorageNames;
    protected int m_Current;

    public String globalInfo() {
        return "Enqueues the incoming data in the queues in internal storage, performing load-balancing by iterating through them.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("storage-name", "storageNames", (Object)new StorageName[0]);
    }

    protected void reset() {
        super.reset();
        this.m_Current = 0;
    }

    public void setStorageNames(StorageName[] value) {
        this.m_StorageNames = value;
        this.reset();
    }

    public StorageName[] getStorageNames() {
        return this.m_StorageNames;
    }

    public String storageNamesTipText() {
        return "The names of the queues in the internal storage.";
    }

    public boolean isUpdatingStorage() {
        return true;
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"storageNames", (Object)(this.m_StorageNames.length == 0 ? "-none-" : Utils.arrayToString((Object)this.m_StorageNames)), (String)"storage: ");
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    protected String check() {
        String result = super.check();
        if (result == null && this.m_StorageNames.length == 0) {
            result = "No queues defined!";
        }
        return result;
    }

    @Override
    protected String doTransmit() {
        String result = null;
        StorageQueueHandler queue = this.getQueue(this.m_StorageNames[this.m_Current]);
        if (queue == null) {
            result = "Queue #" + (this.m_Current + 1) + " not available: " + this.m_StorageNames[this.m_Current];
        } else {
            queue.add(this.m_Input);
        }
        ++this.m_Current;
        if (this.m_Current >= this.m_StorageNames.length) {
            this.m_Current = 0;
        }
        return result;
    }
}

