/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.rats.output;

import adams.core.QuickInfoHelper;
import adams.core.SerializationHelper;
import adams.core.io.AbstractFilenameGenerator;
import adams.core.io.SimpleFilenameGenerator;
import adams.core.option.OptionHandler;
import adams.flow.standalone.rats.output.AbstractRatOutput;

public class Serialize
extends AbstractRatOutput {
    private static final long serialVersionUID = 5871927859523743161L;
    protected AbstractFilenameGenerator m_FilenameGenerator;

    public String globalInfo() {
        return "Saves the objects that it receives using serialization under the filename created by the filename generator.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("filename-generator", "filenameGenerator", (Object)new SimpleFilenameGenerator());
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"generator", (Object)this.m_FilenameGenerator);
    }

    public void setFilenameGenerator(AbstractFilenameGenerator value) {
        this.m_FilenameGenerator = value;
        this.reset();
    }

    public AbstractFilenameGenerator getFilenameGenerator() {
        return this.m_FilenameGenerator;
    }

    public String filenameGeneratorTipText() {
        return "The filename generator to use.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Object.class};
    }

    @Override
    protected String doTransmit() {
        String result = null;
        String filename = this.m_FilenameGenerator.generate((Object)"");
        try {
            SerializationHelper.write((String)filename, (Object)this.m_Input);
        }
        catch (Exception e) {
            result = this.handleException("Failed to write object to " + filename, e);
        }
        return result;
    }
}

