/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.webservice.text;

import adams.core.option.AbstractOptionHandler;
import adams.data.text.TextContainer;
import adams.db.AbstractDatabaseConnection;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.core.RatsTextHelper;
import adams.flow.standalone.DatabaseConnection;
import adams.flow.standalone.rats.input.BufferedRatInput;
import adams.flow.webservice.text.OwnedByRatsTextServiceWS;
import adams.flow.webservice.text.RatsTextServiceWS;
import nz.ac.waikato.adams.webservice.rats.text.RatsTextService;
import nz.ac.waikato.adams.webservice.rats.text.UploadRequest;
import nz.ac.waikato.adams.webservice.rats.text.UploadResponse;

public class SimpleRatsTextService
extends AbstractOptionHandler
implements RatsTextService,
OwnedByRatsTextServiceWS {
    private static final long serialVersionUID = -6102580694812360595L;
    protected RatsTextServiceWS m_Owner;
    protected AbstractDatabaseConnection m_DatabaseConnection;

    public SimpleRatsTextService() {
        this.setOwner(null);
    }

    public String globalInfo() {
        return "Simple implementation of a RATS text webservice.";
    }

    protected AbstractDatabaseConnection getDatabaseConnection() {
        return ActorUtils.getDatabaseConnection((Actor)this.m_Owner.getOwner(), DatabaseConnection.class, (AbstractDatabaseConnection)adams.db.DatabaseConnection.getSingleton());
    }

    @Override
    public void setOwner(RatsTextServiceWS value) {
        this.m_Owner = value;
        this.m_DatabaseConnection = this.m_Owner != null && this.m_Owner.getOwner() != null ? this.getDatabaseConnection() : null;
    }

    @Override
    public RatsTextServiceWS getOwner() {
        return this.m_Owner;
    }

    @Override
    public UploadResponse upload(UploadRequest parameters) {
        this.m_Owner.getLogger().info("upload: " + parameters.getId() + "/" + parameters.getFormat());
        UploadResponse result = new UploadResponse();
        result.setId(parameters.getId());
        result.setFormat(parameters.getFormat());
        result.setSuccess(true);
        TextContainer cont = RatsTextHelper.webserviceToContainer(parameters.getText());
        if (this.isLoggingEnabled()) {
            this.getLogger().fine(cont.toString());
        }
        if (this.getOwner().getRatInput() instanceof BufferedRatInput) {
            ((BufferedRatInput)this.getOwner().getRatInput()).bufferData(cont);
        }
        return result;
    }
}

