/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.flow.core.Actor;
import adams.flow.core.ActorHandler;
import adams.flow.core.ActorUtils;
import adams.flow.core.ExternalActorHandler;
import adams.flow.standalone.Rats;
import adams.flow.standalone.Standalones;
import adams.gui.flow.tree.Node;
import adams.gui.goe.FlowHelper;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class RatFlowHelper
extends FlowHelper {
    public static List<Node> findRats(Container cont) {
        Node current = RatFlowHelper.getEditedNode((Container)cont);
        Node parent = current != null ? (Node)current.getParent() : RatFlowHelper.getEditedParent((Container)cont);
        return RatFlowHelper.findRats(parent);
    }

    public static List<Node> findRats(Node parent) {
        return RatFlowHelper.findRats(parent, true, null);
    }

    public static List<Node> findRats(Node parent, Class[] restrict) {
        return RatFlowHelper.findRats(parent, true, new HashSet<Class>(Arrays.asList(restrict)));
    }

    protected static List<Node> findRats(Node parent, boolean up, HashSet<Class> restrict) {
        ArrayList<Node> result = new ArrayList<Node>();
        if (parent == null) {
            return result;
        }
        while (parent != null) {
            ActorHandler handler;
            if (parent.getActor() instanceof ActorHandler && (handler = (ActorHandler)parent.getActor()).getActorHandlerInfo().canContainStandalones()) {
                Node current;
                Actor actor;
                for (int i = 0; i < parent.getChildCount() && ActorUtils.isStandalone((Actor)(actor = (current = (Node)parent.getChildAt(i)).getActor())); ++i) {
                    int n;
                    if (!actor.getSkip() && actor instanceof Rats) {
                        if (restrict != null && !RatFlowHelper.isRestricted(actor.getClass(), restrict)) continue;
                        result.add(current);
                        continue;
                    }
                    if (actor instanceof Standalones) {
                        for (n = 0; n < current.getChildCount(); ++n) {
                            Actor subactor = ((Node)current.getChildAt(n)).getActor();
                            if (subactor.getSkip() || !(subactor instanceof Rats) || restrict != null && !RatFlowHelper.isRestricted(subactor.getClass(), restrict)) continue;
                            result.add((Node)current.getChildAt(n));
                        }
                        continue;
                    }
                    if (!(actor instanceof ExternalActorHandler)) continue;
                    current.expand();
                    for (n = 0; n < current.getChildCount(); ++n) {
                        result.addAll(RatFlowHelper.findRats((Node)current.getChildAt(n), false, restrict));
                    }
                }
            }
            if (up) {
                parent = (Node)parent.getParent();
                continue;
            }
            parent = null;
        }
        return result;
    }

    public static List<Node> findTopRats(Container cont) {
        Node current = RatFlowHelper.getEditedNode((Container)cont);
        Node parent = current != null ? (Node)current.getParent() : RatFlowHelper.getEditedParent((Container)cont);
        if (parent != null) {
            parent = (Node)parent.getRoot();
        }
        return RatFlowHelper.findTopRats(parent);
    }

    public static List<Node> findTopRats(Node parent) {
        ActorHandler handler;
        ArrayList<Node> result = new ArrayList<Node>();
        if (parent == null) {
            return result;
        }
        if (parent.getActor() instanceof ActorHandler && (handler = (ActorHandler)parent.getActor()).getActorHandlerInfo().canContainStandalones()) {
            Node current;
            Actor actor;
            for (int i = 0; i < parent.getChildCount() && ActorUtils.isStandalone((Actor)(actor = (current = (Node)parent.getChildAt(i)).getActor())); ++i) {
                int n;
                if (!actor.getSkip() && actor instanceof Rats) {
                    result.add(current);
                    continue;
                }
                if (actor instanceof Standalones) {
                    for (n = 0; n < current.getChildCount(); ++n) {
                        Actor subactor = ((Node)current.getChildAt(n)).getActor();
                        if (subactor.getSkip() || !(subactor instanceof Rats)) continue;
                        result.add((Node)current.getChildAt(n));
                    }
                    continue;
                }
                if (!(actor instanceof ExternalActorHandler)) continue;
                current.expand();
                for (n = 0; n < current.getChildCount(); ++n) {
                    result.addAll(RatFlowHelper.findTopRats((Node)current.getChildAt(n)));
                }
            }
        }
        return result;
    }
}

