/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.core.logging.LoggingObject;
import adams.flow.control.AbstractDirectedControlActor;
import adams.flow.core.Actor;
import adams.flow.core.ActorHandler;
import adams.flow.core.ActorUtils;
import adams.flow.core.ExternalActorHandler;
import adams.flow.core.RatReference;
import adams.flow.standalone.Rats;
import java.util.List;

public class RatHelper
extends LoggingObject {
    private static final long serialVersionUID = -763479272812116920L;

    public Actor findRat(ActorHandler group, RatReference name) {
        Actor result = null;
        for (int i = 0; i < group.size(); ++i) {
            ExternalActorHandler external;
            if (group.get(i) instanceof Rats) {
                Rats rats = (Rats)group.get(i);
                int index = rats.indexOf(name.toString());
                if (index <= -1) continue;
                result = rats.get(index);
                break;
            }
            if (group.get(i) instanceof ExternalActorHandler && (external = (ExternalActorHandler)group.get(i)).getExternalActor() instanceof ActorHandler && (result = this.findRat((ActorHandler)external.getExternalActor(), name)) != null) break;
        }
        return result;
    }

    public Actor findRat(Actor root, RatReference name) {
        Actor result = null;
        if (root == null) {
            this.getLogger().severe("No root container found!");
        } else if (!(root instanceof AbstractDirectedControlActor)) {
            this.getLogger().severe("Root is not a container ('" + root.getFullName() + "'/" + root.getClass().getName() + ")!");
            root = null;
        }
        if (root != null) {
            result = this.findRat((ActorHandler)root, name);
        }
        return result;
    }

    public Actor findRatRecursive(Actor actor, RatReference name) {
        Actor result = null;
        List handlers = ActorUtils.findActorHandlers((Actor)actor, (boolean)true);
        for (int i = 0; i < handlers.size() && (result = this.findRat((ActorHandler)handlers.get(i), name)) == null; ++i) {
        }
        return result;
    }

    public static List<Actor> findAllRats(Actor flow) {
        return ActorUtils.enumerate((Actor)flow.getRoot(), (Class[])new Class[]{Rats.class});
    }
}

