/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.Pausable;
import adams.core.logging.LoggingObject;
import adams.event.FlowPauseStateEvent;
import adams.event.FlowPauseStateListener;
import adams.event.RatStateEvent;
import adams.event.RatStateListener;
import adams.flow.core.AbstractDisplay;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.core.PauseStateHandler;
import adams.flow.core.PauseStateManager;
import adams.flow.core.RatMode;
import adams.flow.core.RatState;
import adams.flow.standalone.Rat;
import adams.flow.standalone.Rats;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.GUIHelper;
import adams.gui.core.ParameterPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class RatControl
extends AbstractDisplay
implements FlowPauseStateListener,
RatStateListener {
    private static final long serialVersionUID = 2777897240842864503L;
    protected List<AbstractControlPanel> m_ControlPanels;
    protected List<AbstractControlState> m_ControlStates;

    public String globalInfo() {
        return "Control actor for Rats/Rat actors.";
    }

    protected void initialize() {
        super.initialize();
        this.m_ControlPanels = new ArrayList<AbstractControlPanel>();
        this.m_ControlStates = new ArrayList<AbstractControlState>();
    }

    protected boolean getDefaultDisplayInEditor() {
        return true;
    }

    protected boolean deregisterInWrapUp() {
        return true;
    }

    public List<AbstractControlPanel> getControlPanels() {
        return this.m_ControlPanels;
    }

    public List<AbstractControlState> getControlStates() {
        return this.m_ControlStates;
    }

    public void clearPanel() {
    }

    protected BasePanel newPanel() {
        ParameterPanel param = new ParameterPanel();
        List list = ActorUtils.findClosestTypes((Actor)this, Rats.class, (boolean)true);
        for (Actor item : list) {
            Rats rats = (Rats)item;
            RatsControlPanel cpanel = new RatsControlPanel();
            cpanel.setActor(rats);
            param.addParameter(rats.getName(), (Component)((Object)cpanel));
            this.m_ControlPanels.add(cpanel);
            boolean inControl = false;
            for (int i = 0; i < rats.size(); ++i) {
                Rat rat = (Rat)rats.get(i);
                if (!rat.getShowInControl()) continue;
                rat.addRatStateListener(this);
                inControl = true;
                RatControlPanel subcpanel = new RatControlPanel();
                subcpanel.setPausable(rat.getMode() == RatMode.CONTINUOUS);
                subcpanel.setActor(rat);
                param.addParameter(" - " + rat.getName(), (Component)((Object)subcpanel));
                this.m_ControlPanels.add(subcpanel);
            }
            cpanel.setPausable(!inControl);
        }
        JPanel panel = new JPanel(new FlowLayout(2));
        JButton buttonStop = new JButton("Stop");
        buttonStop.addActionListener(e -> this.getRoot().stopExecution());
        panel.add(buttonStop);
        BasePanel result = new BasePanel((LayoutManager)new BorderLayout());
        result.add((Component)new BaseScrollPane((Component)param), (Object)"Center");
        result.add((Component)panel, (Object)"South");
        this.setUpControlStates();
        return result;
    }

    protected void setUpControlStates() {
        List list = ActorUtils.findClosestTypes((Actor)this, Rats.class, (boolean)true);
        for (Actor item : list) {
            Rats rats = (Rats)item;
            RatsControlState cstate = new RatsControlState();
            cstate.setActor(rats);
            this.m_ControlStates.add(cstate);
            boolean inControl = false;
            for (int i = 0; i < rats.size(); ++i) {
                Rat rat = (Rat)rats.get(i);
                if (!rat.getShowInControl()) continue;
                rat.addRatStateListener(this);
                inControl = true;
                RatControlState subcstate = new RatControlState();
                subcstate.setPausable(rat.getMode() == RatMode.CONTINUOUS);
                subcstate.setActor(rat);
                this.m_ControlStates.add(subcstate);
            }
            cstate.setPausable(!inControl);
        }
    }

    protected Runnable newDisplayRunnable() {
        Runnable result = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (RatControl.this.getCreateFrame() && !RatControl.this.m_Frame.isVisible()) {
                    RatControl.this.m_Frame.setVisible(true);
                }
                for (AbstractControlPanel panel : RatControl.this.m_ControlPanels) {
                    panel.updateButtons();
                }
                Actor actor = RatControl.this.m_Self;
                synchronized (actor) {
                    RatControl.this.m_Self.notifyAll();
                }
                RatControl.this.m_Updating = false;
            }
        };
        return result;
    }

    public String setUp() {
        PauseStateManager manager;
        String result = super.setUp();
        if (result == null && this.getRoot() instanceof PauseStateHandler && (manager = ((PauseStateHandler)this.getRoot()).getPauseStateManager()) != null) {
            manager.addListener((FlowPauseStateListener)this);
        }
        return result;
    }

    protected String doExecute() {
        if (!this.isHeadless()) {
            return super.doExecute();
        }
        this.setUpControlStates();
        return null;
    }

    public void flowPauseStateChanged(FlowPauseStateEvent e) {
        SwingUtilities.invokeLater(() -> {
            for (AbstractControlPanel panel : this.m_ControlPanels) {
                panel.updateButtons();
            }
        });
    }

    @Override
    public void ratStateChanged(RatStateEvent e) {
        SwingUtilities.invokeLater(() -> {
            for (AbstractControlPanel panel : this.m_ControlPanels) {
                RatControlPanel rpanel;
                if (!(panel instanceof RatControlPanel) || (rpanel = (RatControlPanel)panel).getActor() != e.getRat()) continue;
                panel.updateButtons();
                break;
            }
        });
    }

    public void cleanUp() {
        PauseStateManager manager;
        this.m_ControlPanels.clear();
        this.m_ControlStates.clear();
        if (this.getRoot() instanceof PauseStateHandler && (manager = ((PauseStateHandler)this.getRoot()).getPauseStateManager()) != null) {
            manager.removeListener((FlowPauseStateListener)this);
        }
        super.cleanUp();
    }

    public static class RatControlState
    extends AbstractControlState<Rat> {
        private static final long serialVersionUID = 4516229240505598425L;
        protected boolean m_StopStart;

        public String stopOrStart() {
            if (this.m_Actor == null) {
                return null;
            }
            String result = null;
            if (((Rat)this.m_Actor).isRunnableActive()) {
                ((Rat)this.m_Actor).stopRunnable();
            } else {
                result = ((Rat)this.m_Actor).startRunnable();
            }
            return result;
        }

        public void updateButtons() {
            if (this.m_Actor == null) {
                return;
            }
            this.m_PauseResume = ((Rat)this.m_Actor).isRunnableActive();
        }

        public void setStoppable(boolean value) {
            this.m_StopStart = value;
        }

        public boolean isStoppable() {
            return this.m_StopStart;
        }
    }

    public static class RatsControlState
    extends AbstractControlState<Rats> {
        private static final long serialVersionUID = 4516229240505598425L;
    }

    public static abstract class AbstractControlState<T extends Actor & Pausable>
    extends LoggingObject {
        private static final long serialVersionUID = -5965060223206287867L;
        protected T m_Actor;
        protected boolean m_PauseResume;

        public void setActor(T value) {
            this.m_Actor = value;
        }

        public T getActor() {
            return this.m_Actor;
        }

        public void pauseOrResume() {
            if (this.m_Actor == null) {
                return;
            }
            if (((Pausable)this.m_Actor).isPaused()) {
                ((Pausable)this.m_Actor).resumeExecution();
            } else {
                ((Pausable)this.m_Actor).pauseExecution();
            }
        }

        public void setPausable(boolean value) {
            this.m_PauseResume = value;
        }

        public boolean isPausable() {
            return this.m_PauseResume;
        }
    }

    public static class RatControlPanel
    extends AbstractControlPanel<Rat> {
        private static final long serialVersionUID = 4516229240505598425L;
        protected JButton m_ButtonStopStart;

        @Override
        protected void initGUI() {
            super.initGUI();
            this.m_ButtonStopStart = new JButton(GUIHelper.getIcon((String)"run.gif"));
            this.m_ButtonStopStart.addActionListener(e -> this.stopOrStart());
            this.add(this.m_ButtonStopStart);
        }

        public String stopOrStart() {
            if (this.m_Actor == null) {
                return null;
            }
            String result = null;
            if (((Rat)this.m_Actor).isRunnableActive()) {
                ((Rat)this.m_Actor).stopRunnable();
            } else {
                if (((Rat)this.m_Actor).getInitialState() == RatState.PAUSED) {
                    ((Rat)this.m_Actor).setInitialState(RatState.RUNNING);
                }
                result = ((Rat)this.m_Actor).startRunnable();
            }
            this.updateButtons();
            return result;
        }

        @Override
        public void updateButtons() {
            if (this.m_Actor == null) {
                return;
            }
            this.m_ButtonPauseResume.setEnabled(((Rat)this.m_Actor).isRunnableActive());
            if (((Rat)this.m_Actor).isRunnableActive() && ((Rat)this.m_Actor).isPaused()) {
                this.m_ButtonPauseResume.setIcon(GUIHelper.getIcon((String)"resume.gif"));
            } else {
                this.m_ButtonPauseResume.setIcon(GUIHelper.getIcon((String)"pause.gif"));
            }
            if (((Rat)this.m_Actor).isRunnableActive()) {
                this.m_ButtonStopStart.setIcon(GUIHelper.getIcon((String)"stop_blue.gif"));
            } else {
                this.m_ButtonStopStart.setIcon(GUIHelper.getIcon((String)"run.gif"));
            }
        }

        public void setStoppable(boolean value) {
            this.m_ButtonStopStart.setVisible(value);
        }

        public boolean isStoppable() {
            return this.m_ButtonStopStart.isVisible();
        }
    }

    public static class RatsControlPanel
    extends AbstractControlPanel<Rats> {
        private static final long serialVersionUID = 4516229240505598425L;
    }

    public static abstract class AbstractControlPanel<T extends Actor & Pausable>
    extends BasePanel {
        private static final long serialVersionUID = -5965060223206287867L;
        protected T m_Actor;
        protected JButton m_ButtonPauseResume;

        protected void initGUI() {
            super.initGUI();
            this.setLayout(new FlowLayout(0, 5, 1));
            this.m_ButtonPauseResume = new JButton(GUIHelper.getIcon((String)"pause.gif"));
            this.m_ButtonPauseResume.addActionListener(e -> this.pauseOrResume());
            this.add(this.m_ButtonPauseResume);
        }

        protected void finishInit() {
            super.finishInit();
            this.updateButtons();
        }

        public void setActor(T value) {
            this.m_Actor = value;
            this.updateButtons();
        }

        public T getActor() {
            return this.m_Actor;
        }

        public void pauseOrResume() {
            if (this.m_Actor == null) {
                return;
            }
            if (((Pausable)this.m_Actor).isPaused()) {
                ((Pausable)this.m_Actor).resumeExecution();
            } else {
                ((Pausable)this.m_Actor).pauseExecution();
            }
            this.updateButtons();
        }

        public void updateButtons() {
            if (this.m_Actor == null) {
                return;
            }
            if (((Pausable)this.m_Actor).isPaused()) {
                this.m_ButtonPauseResume.setIcon(GUIHelper.getIcon((String)"resume.gif"));
            } else {
                this.m_ButtonPauseResume.setIcon(GUIHelper.getIcon((String)"pause.gif"));
            }
        }

        public void setPausable(boolean value) {
            this.m_ButtonPauseResume.setVisible(value);
        }

        public boolean isPausable() {
            return this.m_ButtonPauseResume.isVisible();
        }
    }
}

