/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.Pausable;
import adams.flow.core.Actor;
import adams.flow.core.ActorExecution;
import adams.flow.core.ActorHandlerInfo;
import adams.flow.core.ActorReferenceHandler;
import adams.flow.core.ActorReferenceHandlerHelper;
import adams.flow.standalone.AbstractStandaloneMutableGroup;
import adams.flow.standalone.LabRat;
import adams.flow.standalone.Rat;
import java.util.ArrayList;
import java.util.List;

public class Rats
extends AbstractStandaloneMutableGroup<Rat>
implements Pausable,
ActorReferenceHandler {
    private static final long serialVersionUID = -6092821156832607603L;
    protected boolean m_Paused;

    public String globalInfo() {
        return "Encapsulates all Rat setups.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("rat", "rats", (Object)new Actor[0]);
    }

    protected void initialize() {
        super.initialize();
        this.m_Paused = false;
    }

    protected List<Rat> getDefaultActors() {
        return new ArrayList<Rat>();
    }

    public void setRats(Actor[] value) {
        for (int i = 0; i < value.length; ++i) {
            String msg = this.checkActor(value[i], i);
            if (msg == null) continue;
            this.getLogger().warning(msg);
            return;
        }
        this.m_Actors.clear();
        for (Actor actor : value) {
            this.m_Actors.add((Rat)actor);
        }
        this.reset();
        this.updateParent();
    }

    public Actor[] getRats() {
        return this.m_Actors.toArray(new Actor[this.m_Actors.size()]);
    }

    public String ratsTipText() {
        return "The reception/transmission setups.";
    }

    public ActorHandlerInfo getActorHandlerInfo() {
        return new ActorHandlerInfo(true, false, ActorExecution.UNDEFINED, false, new Class[]{Rat.class, LabRat.class});
    }

    public Class[] getProhibitedPrecedingActorReferenceHandlers() {
        return new Class[0];
    }

    public String checkActorReferenceHandlers() {
        return ActorReferenceHandlerHelper.checkActorReferenceHandlers((ActorReferenceHandler)this);
    }

    public boolean isReferencingRequired() {
        return false;
    }

    protected String checkActor(Actor actor, int index) {
        if (!(actor instanceof Rat) && !(actor instanceof LabRat)) {
            return "Actor" + (index > -1 ? " #" + (index + 1) : "") + " is neither " + Rat.class.getName() + " nor " + LabRat.class.getName() + ", provided: " + actor.getClass().getName();
        }
        return null;
    }

    public String check() {
        return this.checkActorReferenceHandlers();
    }

    protected String doExecute() {
        String result = null;
        for (int i = 0; i < this.m_Actors.size(); ++i) {
            if (((Rat)((Object)this.m_Actors.get(i))).getSkip()) continue;
            try {
                result = ((Rat)((Object)this.m_Actors.get(i))).execute();
                if (result == null) continue;
                result = "Rat #" + (i + 1) + " failed: " + result;
                break;
            }
            catch (Exception e) {
                result = this.handleException("Failed to execute Rat #" + (i + 1), e);
            }
        }
        return result;
    }

    public void pauseExecution() {
        for (int i = 0; i < this.size(); ++i) {
            ((Rat)this.get(i)).pauseExecution();
        }
        this.m_Paused = true;
    }

    public boolean isPaused() {
        return this.m_Paused;
    }

    public void resumeExecution() {
        for (int i = 0; i < this.size(); ++i) {
            ((Rat)this.get(i)).resumeExecution();
        }
        this.m_Paused = false;
    }
}

