/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.rats.input;

import adams.flow.standalone.rats.input.AbstractRatInput;
import adams.flow.standalone.rats.input.BufferedRatInput;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public abstract class AbstractBufferedRatInput
extends AbstractRatInput
implements BufferedRatInput {
    private static final long serialVersionUID = -2564424816778971430L;
    protected int m_MaxBuffer;
    protected BlockingQueue m_Buffer;
    protected Object m_Current;
    protected int m_PollTimeout;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("max-buffer", "maxBuffer", (Object)65535, (Number)1, null);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_PollTimeout = 100;
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_Buffer = new ArrayBlockingQueue(this.m_MaxBuffer);
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Using buffer size: " + this.m_MaxBuffer);
            }
        }
        return result;
    }

    @Override
    public void setMaxBuffer(int value) {
        if (this.getOptionManager().isValid("maxBuffer", (Number)value)) {
            this.m_MaxBuffer = value;
            this.reset();
        }
    }

    @Override
    public int getMaxBuffer() {
        return this.m_MaxBuffer;
    }

    @Override
    public String maxBufferTipText() {
        return "The maximum number of items to buffer.";
    }

    @Override
    public void bufferData(Object value) {
        this.m_Buffer.add(value);
    }

    protected Object poll() {
        Object result = null;
        while (this.canReceive() && result == null) {
            try {
                result = this.m_Buffer.poll(this.m_PollTimeout, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                if (!this.isLoggingEnabled()) continue;
                this.getLogger().log(Level.INFO, "Exception while polling", (Throwable)e);
            }
        }
        return result;
    }

    @Override
    public boolean hasPendingOutput() {
        this.m_Current = this.poll();
        return this.m_Current != null && !this.m_Stopped;
    }

    @Override
    public Object output() {
        Object result;
        if (this.m_Current != null) {
            result = this.m_Current;
            this.m_Current = null;
        } else {
            result = this.poll();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopExecution() {
        super.stopExecution();
        if (this.m_Buffer != null) {
            BlockingQueue blockingQueue = this.m_Buffer;
            synchronized (blockingQueue) {
                this.m_Buffer.notifyAll();
            }
        }
    }

    @Override
    public void cleanUp() {
        this.m_Buffer.clear();
        super.cleanUp();
    }
}

