/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.rats.input;

import adams.core.ArrayProvider;
import adams.core.AtomicMoveSupporter;
import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.base.BaseRegExp;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.core.io.fileuse.AbstractFileUseCheck;
import adams.core.io.fileuse.Default;
import adams.core.io.lister.LocalDirectoryLister;
import adams.core.io.lister.Sorting;
import adams.core.logging.LoggingLevel;
import adams.core.option.OptionHandler;
import adams.flow.standalone.rats.input.AbstractRatInput;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class FileLister
extends AbstractRatInput
implements AtomicMoveSupporter,
ArrayProvider {
    private static final long serialVersionUID = 4089376907540465883L;
    protected LocalDirectoryLister m_Lister;
    protected List<String> m_Files;
    protected int m_WaitList;
    protected boolean m_MoveFiles;
    protected boolean m_SkipInUse;
    protected AbstractFileUseCheck m_Check;
    protected boolean m_AtomicMove;
    protected PlaceholderDirectory m_Target;
    protected boolean m_OutputArray;
    protected boolean m_ReportMovingErrors;

    public String globalInfo() {
        return "Polls files in a directory and forwards them.\nIt can skip files that are currently flagged as 'in use'.\nMoving files to the specified target directory will continue, even if errors are occurred with some files (NB: you may end up with a very large error message if all files from a large list of files are failing).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("source", "source", (Object)new PlaceholderDirectory());
        this.m_OptionManager.add("regexp", "regExp", (Object)new BaseRegExp(".*"));
        this.m_OptionManager.add("max-files", "maxFiles", (Object)-1, (Number)-1, null);
        this.m_OptionManager.add("sorting", "sorting", (Object)Sorting.NO_SORTING);
        this.m_OptionManager.add("sort-descending", "sortDescending", (Object)false);
        this.m_OptionManager.add("wait-list", "waitList", (Object)0, (Number)0, null);
        this.m_OptionManager.add("move-files", "moveFiles", (Object)false);
        this.m_OptionManager.add("skip-in-use", "skipInUse", (Object)false);
        this.m_OptionManager.add("check", "check", (Object)new Default());
        this.m_OptionManager.add("atomic-move", "atomicMove", (Object)false);
        this.m_OptionManager.add("target", "target", (Object)new PlaceholderDirectory());
        this.m_OptionManager.add("output-array", "outputArray", (Object)false);
        this.m_OptionManager.add("report-moving-errors", "reportMovingErrors", (Object)false);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Lister = new LocalDirectoryLister();
        this.m_Lister.setListDirs(false);
        this.m_Lister.setListFiles(true);
        this.m_Lister.setRecursive(false);
        this.m_Files = new ArrayList<String>();
    }

    public synchronized void setLoggingLevel(LoggingLevel value) {
        super.setLoggingLevel(value);
        this.m_Lister.setLoggingLevel(value);
    }

    public void setSource(PlaceholderDirectory value) {
        this.m_Lister.setWatchDir(value.getAbsolutePath());
        this.reset();
    }

    public PlaceholderDirectory getSource() {
        return new PlaceholderDirectory(this.m_Lister.getWatchDir());
    }

    public String sourceTipText() {
        return "The directory to watch for incoming files.";
    }

    public void setRegExp(BaseRegExp value) {
        this.m_Lister.setRegExp(value);
        this.reset();
    }

    public BaseRegExp getRegExp() {
        return this.m_Lister.getRegExp();
    }

    public String regExpTipText() {
        return "The regular expression that the files must match.";
    }

    public void setMaxFiles(int value) {
        this.m_Lister.setMaxItems(value);
        this.reset();
    }

    public int getMaxFiles() {
        return this.m_Lister.getMaxItems();
    }

    public String maxFilesTipText() {
        return "The maximum number of files to list; -1 for unlimited.";
    }

    public void setSorting(Sorting value) {
        this.m_Lister.setSorting(value);
        this.reset();
    }

    public Sorting getSorting() {
        return this.m_Lister.getSorting();
    }

    public String sortingTipText() {
        return "The type of sorting to perform.";
    }

    public void setSortDescending(boolean value) {
        this.m_Lister.setSortDescending(value);
        this.reset();
    }

    public boolean getSortDescending() {
        return this.m_Lister.getSortDescending();
    }

    public String sortDescendingTipText() {
        return "If enabled, the sort direction is descending.";
    }

    public void setWaitList(int value) {
        if (value >= 0) {
            this.m_WaitList = value;
            this.reset();
        } else {
            this.getLogger().warning("Number of milli-seconds to wait must be >=0, provided: " + value);
        }
    }

    public int getWaitList() {
        return this.m_WaitList;
    }

    public String waitListTipText() {
        return "The number of milli-seconds to wait after listing the files.";
    }

    public void setMoveFiles(boolean value) {
        this.m_MoveFiles = value;
        this.reset();
    }

    public boolean getMoveFiles() {
        return this.m_MoveFiles;
    }

    public String moveFilesTipText() {
        return "If enabled, the files get moved to the specified directory first before being transmitted (with their new filename).";
    }

    public void setSkipInUse(boolean value) {
        this.m_SkipInUse = value;
        this.reset();
    }

    public boolean getSkipInUse() {
        return this.m_SkipInUse;
    }

    public String skipInUseTipText() {
        return "If enabled, then files are that currently 'in use' get removed from the list.";
    }

    public void setCheck(AbstractFileUseCheck value) {
        this.m_Check = value;
        this.reset();
    }

    public AbstractFileUseCheck getCheck() {
        return this.m_Check;
    }

    public String checkTipText() {
        return "If scheme to use checking the 'in use' state of a file.";
    }

    public void setAtomicMove(boolean value) {
        this.m_AtomicMove = value;
        this.reset();
    }

    public boolean getAtomicMove() {
        return this.m_AtomicMove;
    }

    public String atomicMoveTipText() {
        return "If true, then an atomic move operation will be attempted (NB: not supported by all operating systems).";
    }

    public void setTarget(PlaceholderDirectory value) {
        this.m_Target = value;
        this.reset();
    }

    public PlaceholderDirectory getTarget() {
        return this.m_Target;
    }

    public String targetTipText() {
        return "The directory to move the files to before transmitting their names.";
    }

    public void setOutputArray(boolean value) {
        this.m_OutputArray = value;
        this.reset();
    }

    public boolean getOutputArray() {
        return this.m_OutputArray;
    }

    public String outputArrayTipText() {
        return "If enabled, the files get output as array rather than one-by-one.";
    }

    public void setReportMovingErrors(boolean value) {
        this.m_ReportMovingErrors = value;
        this.reset();
    }

    public boolean getReportMovingErrors() {
        return this.m_ReportMovingErrors;
    }

    public String reportMovingErrorsTipText() {
        return "If enabled, errors encountered while moving files get reported rather than just logged as warnings.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"source", (Object)this.getSource(), (String)"source: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"regExp", (BaseRegExp)this.getRegExp(), (String)", regexp: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"waitList", (Object)this.getWaitList(), (String)", wait-list: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"moveFiles", (Object)(this.getMoveFiles() ? "move" : "keep"), (String)", ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"target", (Object)this.getTarget(), (String)", target: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"outputArray", (Object)(this.getOutputArray() ? "as array" : "one-by-one"), (String)", ");
        return result;
    }

    @Override
    public String check() {
        String result = super.check();
        if (result == null && !this.getSource().exists()) {
            result = "Source directory does not exist: " + this.getSource();
        }
        if (result == null && !this.getSource().isDirectory()) {
            result = "Source is not a directory: " + this.getSource();
        }
        if (this.m_MoveFiles) {
            if (result == null && !this.getTarget().exists()) {
                result = "Target directory does not exist: " + this.getTarget();
            }
            if (result == null && !this.getTarget().isDirectory()) {
                result = "Target is not a directory: " + this.getTarget();
            }
        }
        return result;
    }

    @Override
    public Class generates() {
        if (this.m_OutputArray) {
            return String[].class;
        }
        return String.class;
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_Files.size() > 0;
    }

    @Override
    public Object output() {
        if (this.m_OutputArray) {
            return this.m_Files.toArray(new String[this.m_Files.size()]);
        }
        return this.m_Files.remove(0);
    }

    @Override
    protected String doReceive() {
        String result = null;
        ArrayList<String> files = new ArrayList<String>(Arrays.asList(this.m_Lister.list()));
        this.doWait(this.m_WaitList);
        if (files.size() > 0) {
            PlaceholderFile file;
            int i = 0;
            while (i < files.size()) {
                file = new PlaceholderFile((String)files.get(i));
                if (this.m_SkipInUse && this.m_Check.isInUse((File)file)) {
                    if (this.isLoggingEnabled()) {
                        this.getLogger().fine("File in use: " + (String)files.get(i));
                    }
                    files.remove(i);
                    continue;
                }
                ++i;
            }
            if (this.m_MoveFiles) {
                MessageCollection errors = new MessageCollection();
                for (i = 0; i < files.size(); ++i) {
                    file = new PlaceholderFile((String)files.get(i));
                    try {
                        if (!FileUtils.move((File)file, (File)this.m_Target, (boolean)this.m_AtomicMove)) {
                            errors.add("Failed to move '" + file + "' to '" + this.m_Target + "'!");
                            continue;
                        }
                        this.m_Files.add(i, this.m_Target.getAbsolutePath() + File.separator + file.getName());
                        continue;
                    }
                    catch (Exception e) {
                        errors.add("Failed to move '" + file + "' to '" + this.m_Target + "': ", (Throwable)e);
                    }
                }
                if (!errors.isEmpty()) {
                    if (this.m_ReportMovingErrors) {
                        result = errors.toString();
                    } else {
                        this.getLogger().warning(errors.toString());
                    }
                }
            } else {
                this.m_Files.addAll(files);
            }
        }
        return result;
    }
}

