/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.rats.input;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.control.StorageName;
import adams.flow.control.StorageUser;
import adams.flow.core.Unknown;
import adams.flow.standalone.rats.input.AbstractRatInput;

public class Storage
extends AbstractRatInput
implements StorageUser {
    private static final long serialVersionUID = 6942772195383207110L;
    protected StorageName m_StorageName;
    protected Object m_Output;

    public String globalInfo() {
        return "Outputs the specified storage item, if possible.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("storage-name", "storageName", (Object)new StorageName());
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Output = null;
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
        this.reset();
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public String storageNameTipText() {
        return "The name of the item in internal storage.";
    }

    public boolean isUsingStorage() {
        return true;
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"storageName", (Object)this.m_StorageName, (String)"storage: ");
    }

    @Override
    public Class generates() {
        return Unknown.class;
    }

    @Override
    protected String doReceive() {
        this.m_Output = null;
        adams.flow.control.Storage storage = this.getOwner().getStorageHandler().getStorage();
        if (storage.has(this.m_StorageName)) {
            this.m_Output = storage.get(this.m_StorageName);
        }
        return null;
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_Output != null;
    }

    @Override
    public Object output() {
        Object result = this.m_Output;
        this.m_Output = null;
        return result;
    }
}

