/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.rats.input;

import adams.core.QuickInfoHelper;
import adams.core.VariableName;
import adams.core.Variables;
import adams.core.option.OptionHandler;
import adams.flow.standalone.rats.input.AbstractRatInput;

public class Variable
extends AbstractRatInput {
    private static final long serialVersionUID = 6942772195383207110L;
    protected VariableName m_VariableName;
    protected Object m_Output;

    public String globalInfo() {
        return "Outputs the specified variable, if possible.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("variable-name", "variableName", (Object)new VariableName());
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Output = null;
    }

    public void setVariableName(VariableName value) {
        this.m_VariableName = value;
        this.reset();
    }

    public VariableName getVariableName() {
        return this.m_VariableName;
    }

    public String variableNameTipText() {
        return "The name of variable to output.";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"variableName", (Object)this.m_VariableName, (String)"variable: ");
    }

    @Override
    public Class generates() {
        return String.class;
    }

    @Override
    protected String doReceive() {
        this.m_Output = null;
        Variables variables = this.getOwner().getVariables();
        if (variables.has(this.m_VariableName.getValue())) {
            this.m_Output = variables.get(this.m_VariableName.getValue());
        }
        return null;
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_Output != null;
    }

    @Override
    public Object output() {
        Object result = this.m_Output;
        this.m_Output = null;
        return result;
    }
}

