/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.rats.input;

import adams.event.WebServiceClientProducerResponseDataEvent;
import adams.event.WebServiceClientProducerResponseDataListener;
import adams.flow.core.Actor;
import adams.flow.core.Unknown;
import adams.flow.standalone.rats.input.AbstractBufferedRatInput;
import adams.flow.webservice.WebServiceClient;
import adams.flow.webservice.WebServiceClientConsumer;
import adams.flow.webservice.WebServiceClientProducer;
import com.example.customerservice.flow.CustomersByName;

public class WebserviceInput
extends AbstractBufferedRatInput
implements WebServiceClientProducerResponseDataListener {
    private static final long serialVersionUID = -3681678330127394451L;
    protected WebServiceClient m_Client;

    public String globalInfo() {
        return "Uses a webservice for retrieving data from a webservice. Needs to be wrapped in poller.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("client", "client", (Object)this.getDefaultClient());
    }

    protected WebServiceClientConsumer getDefaultClient() {
        return new CustomersByName();
    }

    protected String checkClient(WebServiceClient value) {
        if (!(value instanceof WebServiceClientProducer)) {
            return "Does not implement " + WebServiceClientProducer.class.getName() + "!";
        }
        return null;
    }

    public void setClient(WebServiceClient value) {
        String msg = this.checkClient(value);
        if (msg == null) {
            ((WebServiceClientProducer)this.m_Client).removeResponseDataListener((WebServiceClientProducerResponseDataListener)this);
            this.m_Client = value;
            this.m_Client.setOwner((Actor)this.getOwner());
            ((WebServiceClientProducer)this.m_Client).addResponseDataListener((WebServiceClientProducerResponseDataListener)this);
            this.reset();
        } else {
            this.getLogger().severe("Failed to set client: " + msg);
        }
    }

    public WebServiceClient getClient() {
        return this.m_Client;
    }

    public String clientTipText() {
        return "The webservice client to use.";
    }

    @Override
    public Class generates() {
        if (this.m_Client != null) {
            return ((WebServiceClientConsumer)this.m_Client).accepts()[0];
        }
        return Unknown.class;
    }

    @Override
    protected String doReceive() {
        String result = null;
        try {
            this.m_Client.setOwner((Actor)this.getOwner());
            ((WebServiceClientProducer)this.m_Client).addResponseDataListener((WebServiceClientProducerResponseDataListener)this);
            this.m_Client.query();
        }
        catch (Exception e) {
            result = this.handleException("Failed to receive data from webservice!", e);
        }
        return result;
    }

    public void webServiceReponseDataReceived(WebServiceClientProducerResponseDataEvent e) {
        this.m_Buffer.add(e.getProducer().getResponseData());
    }

    @Override
    public void cleanUp() {
        if (this.m_Client != null) {
            ((WebServiceClientProducer)this.m_Client).removeResponseDataListener((WebServiceClientProducerResponseDataListener)this);
        }
        super.cleanUp();
    }
}

