/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.rats.output;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.flow.container.AbstractContainer;
import adams.flow.core.Compatibility;
import adams.flow.standalone.rats.output.AbstractMetaRatOutput;

public class ContainerValuePicker
extends AbstractMetaRatOutput {
    private static final long serialVersionUID = 4772521690328020172L;
    protected String m_ValueName;

    public String globalInfo() {
        return "Extracts the specified value from the container and passes this on to the base rat output scheme.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("value", "valueName", (Object)"");
    }

    public void setValueName(String value) {
        this.m_ValueName = value;
        this.reset();
    }

    public String getValueName() {
        return this.m_ValueName;
    }

    public String valueNameTipText() {
        return "The name of the value to extract.";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"valueName", (Object)this.m_ValueName);
    }

    @Override
    public Class[] accepts() {
        return new Class[]{AbstractContainer.class};
    }

    @Override
    protected String callTransmit() {
        AbstractContainer cont = (AbstractContainer)this.m_Input;
        Object input = cont.getValue(this.m_ValueName);
        if (input != null) {
            Compatibility comp = new Compatibility();
            if (comp.isCompatible(new Class[]{input.getClass()}, this.m_Output.accepts())) {
                this.m_Output.input(input);
                return this.m_Output.transmit();
            }
            return "Container content of type '" + input.getClass() + "' is not compatible with base outputs accepted input: " + Utils.classesToString((Class[])this.m_Output.accepts());
        }
        return "No value named '" + this.m_ValueName + "' in container!";
    }
}

