/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.rats.output;

import adams.core.Placeholders;
import adams.core.QuickInfoHelper;
import adams.core.management.ProcessUtils;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.flow.core.Unknown;
import adams.flow.standalone.rats.output.AbstractRatOutput;
import com.github.fracpete.processoutput4j.output.CollectingProcessOutput;

public class Exec
extends AbstractRatOutput {
    private static final long serialVersionUID = 2950260223110007595L;
    protected String m_Command;
    protected boolean m_CommandContainsPlaceholder;
    protected boolean m_CommandContainsVariable;
    protected transient CollectingProcessOutput m_ProcessOutput;

    public String globalInfo() {
        return "Executes the specified command when the rat finishes execution.\nIgnores any input.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("cmd", "command", (Object)"ls -l .");
        this.m_OptionManager.add("placeholder", "commandContainsPlaceholder", (Object)false);
        this.m_OptionManager.add("variable", "commandContainsVariable", (Object)false);
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"command", (Object)this.m_Command);
    }

    public void setCommand(String value) {
        this.m_Command = value;
        this.reset();
    }

    public String getCommand() {
        return this.m_Command;
    }

    public String commandTipText() {
        return "The external command to run.";
    }

    public void setCommandContainsPlaceholder(boolean value) {
        this.m_CommandContainsPlaceholder = value;
        this.reset();
    }

    public boolean getCommandContainsPlaceholder() {
        return this.m_CommandContainsPlaceholder;
    }

    public String commandContainsPlaceholderTipText() {
        return "Set this to true to enable automatic placeholder expansion for the command string.";
    }

    public void setCommandContainsVariable(boolean value) {
        this.m_CommandContainsVariable = value;
        this.reset();
    }

    public boolean getCommandContainsVariable() {
        return this.m_CommandContainsVariable;
    }

    public String commandContainsVariableTipText() {
        return "Set this to true to enable automatic variable expansion for the command string.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    protected String doTransmit() {
        String result = null;
        String cmd = this.m_Command;
        if (this.m_CommandContainsVariable) {
            cmd = this.getOwner().getVariables().expand(cmd);
        }
        if (this.m_CommandContainsPlaceholder) {
            cmd = Placeholders.getSingleton().expand(cmd).replace("\\", "/");
        }
        try {
            this.m_ProcessOutput = ProcessUtils.execute((String[])OptionUtils.splitOptions((String)cmd));
            if (!this.m_ProcessOutput.hasSucceeded()) {
                result = ProcessUtils.toErrorOutput((CollectingProcessOutput)this.m_ProcessOutput);
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to execute command: " + cmd, e);
        }
        this.m_ProcessOutput = null;
        return result;
    }

    @Override
    public void stopExecution() {
        if (this.m_ProcessOutput != null) {
            this.m_ProcessOutput.destroy();
        }
        super.stopExecution();
    }
}

