/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.rats.output;

import adams.flow.core.Actor;
import adams.flow.core.FlowContextHandler;
import adams.flow.standalone.rats.output.AbstractRatOutput;
import adams.flow.websocket.client.SimpleSendGenerator;
import adams.flow.websocket.client.WebSocketClientGenerator;
import com.pusher.java_websocket.client.WebSocketClient;
import java.util.logging.Level;

public class WebsocketOutput
extends AbstractRatOutput {
    private static final long serialVersionUID = 7678239063778818441L;
    protected WebSocketClientGenerator m_Generator;
    protected boolean m_Disconnect;
    protected transient WebSocketClient m_Client;

    public String globalInfo() {
        return "Allows to send data to webservices using the supplied client.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("generator", "generator", (Object)new SimpleSendGenerator());
        this.m_OptionManager.add("disconnect", "disconnect", (Object)false);
    }

    public void setGenerator(WebSocketClientGenerator value) {
        this.m_Generator = value;
        this.reset();
    }

    public WebSocketClientGenerator getGenerator() {
        return this.m_Generator;
    }

    public String generatorTipText() {
        return "The client generator to use.";
    }

    public void setDisconnect(boolean value) {
        this.m_Disconnect = value;
        this.reset();
    }

    public boolean getDisconnect() {
        return this.m_Disconnect;
    }

    public String disconnectTipText() {
        return "If enabled, the connection will get closed immediately after sending the data.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String.class, byte[].class};
    }

    @Override
    protected String doTransmit() {
        String result = null;
        if (this.m_Client == null) {
            try {
                this.m_Client = this.m_Generator.generateClient();
                if (this.m_Client instanceof FlowContextHandler) {
                    ((FlowContextHandler)this.m_Client).setFlowContext((Actor)this.getOwner());
                }
            }
            catch (Exception e) {
                result = this.handleException("Failed to generate websocket client!", e);
            }
        }
        if (result == null) {
            try {
                if (!this.m_Client.connectBlocking()) {
                    result = "Failed to establish connection!";
                } else {
                    if (this.m_Input instanceof String) {
                        this.m_Client.send((String)this.m_Input);
                    } else {
                        this.m_Client.send((byte[])this.m_Input);
                    }
                    if (this.m_Disconnect) {
                        try {
                            this.m_Client.closeBlocking();
                        }
                        catch (Exception e) {
                            this.getLogger().log(Level.SEVERE, "Error closing websocket client!", (Throwable)e);
                        }
                    }
                }
            }
            catch (InterruptedException e) {
            }
            catch (Exception e) {
                result = this.handleException("Failed to connect/send data!", e);
            }
        }
        return result;
    }

    @Override
    public void cleanUp() {
        if (this.m_Client != null && this.m_Client.isOpen()) {
            try {
                this.m_Client.closeBlocking();
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Error closing websocket client!", (Throwable)e);
            }
            this.m_Client = null;
        }
        super.cleanUp();
    }
}

