/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.rats.output.enqueue;

import adams.core.StoppableWithFeedback;
import adams.core.Utils;
import adams.core.logging.LoggingObject;
import adams.flow.control.StorageQueueHandler;
import adams.flow.standalone.rats.output.enqueue.AbstractEnqueueGuard;

public class MaxQueueSize
extends AbstractEnqueueGuard {
    private static final long serialVersionUID = 1179005015402094837L;
    protected int m_Limit;
    protected int m_Wait;

    public String globalInfo() {
        return "Ensures that the queue doesn't exceed the specified size; waits till it reaches.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("limit", "limit", (Object)-1, (Number)-1, null);
        this.m_OptionManager.add("wait", "wait", (Object)100, (Number)1, null);
    }

    public void setLimit(int value) {
        this.m_Limit = value;
        this.reset();
    }

    public int getLimit() {
        return this.m_Limit;
    }

    public String limitTipText() {
        return "The maximum allowed queue size.";
    }

    public void setWait(int value) {
        this.m_Wait = value;
        this.reset();
    }

    public int getWait() {
        return this.m_Wait;
    }

    public String waitTipText() {
        return "The time to wait between checks (in msec).";
    }

    @Override
    protected String doEnqueue(StorageQueueHandler handler, Object input) {
        if (this.m_Limit < 1 || handler.size() < this.m_Limit) {
            handler.add(input);
            return null;
        }
        String result = null;
        while (handler.size() >= this.m_Limit) {
            Utils.wait((LoggingObject)this, (StoppableWithFeedback)this, (int)this.m_Wait, (int)50);
            if (this.m_Stopped) {
                result = "Enqueuing stopped!";
                break;
            }
            if (handler.size() >= this.m_Limit) continue;
            handler.add(input);
            break;
        }
        return result;
    }
}

