/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.Utils;
import adams.core.option.AbstractOption;
import adams.flow.core.RatReference;
import adams.flow.standalone.Rats;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseTreeNode;
import adams.gui.core.MouseUtils;
import adams.gui.flow.tree.Node;
import adams.gui.goe.AbstractPropertyEditorSupport;
import adams.gui.goe.CustomStringRepresentationHandler;
import adams.gui.goe.FlowHelper;
import adams.gui.goe.actorpathtree.ActorPathNode;
import adams.gui.goe.ratstree.RatsTree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class RatReferenceEditor
extends AbstractPropertyEditorSupport
implements CustomStringRepresentationHandler {
    protected JTextField m_TextValue;
    protected RatsTree m_Tree;

    public static String toString(AbstractOption option, Object object) {
        return ((RatReference)((Object)object)).getValue();
    }

    public static Object valueOf(AbstractOption option, String str) {
        return new RatReference(str);
    }

    public String toCustomStringRepresentation(Object obj) {
        return RatReferenceEditor.toString(null, obj);
    }

    public Object fromCustomStringRepresentation(String str) {
        return new RatReference(str);
    }

    public String getJavaInitializationString() {
        String result = "new " + RatReference.class.getName() + "(\"" + Utils.backQuoteChars((String)this.getValue().toString()) + "\")";
        return result;
    }

    protected String getStringToPaint() {
        return "" + this.getValue();
    }

    public void paintValue(Graphics gfx, Rectangle box) {
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getHeight()) / 2;
        String val = this.getStringToPaint();
        if (val.isEmpty()) {
            val = "[empty]";
        }
        gfx.drawString(val, 2, fm.getHeight() + vpad);
    }

    protected RatReference parse(String s) {
        RatReference result;
        try {
            result = new RatReference();
            result.setValue(s);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    protected boolean updateValue(TreePath path) {
        ActorPathNode callable;
        BaseTreeNode node;
        boolean result = false;
        if (path != null && (node = (BaseTreeNode)path.getLastPathComponent()) instanceof ActorPathNode && (callable = (ActorPathNode)node).hasClassname()) {
            this.m_TextValue.setText(callable.getLabel());
            result = true;
        }
        return result;
    }

    protected JComponent createCustomEditor() {
        JPanel panelTree = new JPanel(new BorderLayout(0, 5));
        panelTree.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.m_Tree = new RatsTree();
        this.m_Tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                RatReferenceEditor.this.updateValue(e.getPath());
            }
        });
        this.m_Tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TreePath selPath = RatReferenceEditor.this.m_Tree.getPathForLocation(e.getX(), e.getY());
                if (MouseUtils.isDoubleClick((MouseEvent)e) && RatReferenceEditor.this.updateValue(selPath)) {
                    e.consume();
                    RatReferenceEditor.this.acceptInput();
                }
                if (!e.isConsumed()) {
                    super.mousePressed(e);
                }
            }
        });
        panelTree.add((Component)new BaseScrollPane((Component)((Object)this.m_Tree)), "Center");
        panelTree.add((Component)new JLabel("Select callable actor:"), "North");
        JPanel panelAll = new JPanel(new BorderLayout());
        panelTree.add((Component)panelAll, "South");
        JPanel panel = new JPanel(new FlowLayout(0));
        panelAll.add((Component)panel, "Center");
        this.m_TextValue = new JTextField(20);
        this.m_TextValue.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    RatReferenceEditor.this.acceptInput();
                } else if (e.getKeyCode() == 27) {
                    e.consume();
                    RatReferenceEditor.this.discardInput();
                } else {
                    super.keyPressed(e);
                }
            }
        });
        JLabel label = new JLabel("Manual reference");
        label.setDisplayedMnemonic('M');
        label.setLabelFor(this.m_TextValue);
        panel.add(label);
        panel.add(this.m_TextValue);
        JPanel panelButtons = new JPanel(new FlowLayout(2));
        panelAll.add((Component)panelButtons, "South");
        JButton buttonOK = new JButton("OK");
        buttonOK.setMnemonic('O');
        buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RatReferenceEditor.this.acceptInput();
            }
        });
        panelButtons.add(buttonOK);
        JButton buttonClose = new JButton("Cancel");
        buttonClose.setMnemonic('C');
        buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RatReferenceEditor.this.discardInput();
            }
        });
        panelButtons.add(buttonClose);
        return panelTree;
    }

    protected boolean isValid(String s) {
        return ((RatReference)((Object)this.getValue())).isValid(s);
    }

    protected boolean isUnchanged(String s) {
        return s.equals(((RatReference)((Object)this.getValue())).getValue());
    }

    protected void acceptInput() {
        String s = this.m_TextValue.getText();
        if (this.isValid(s) && !this.isUnchanged(s)) {
            this.setValue((Object)this.parse(s));
        }
        this.closeDialog(1);
    }

    protected void discardInput() {
        this.closeDialog(0);
    }

    protected List<String> findRats() {
        ArrayList<String> result = new ArrayList<String>();
        List callables = FlowHelper.findNodes((Container)this.m_CustomEditor, Rats.class);
        for (Node callable : callables) {
            result.add(callable.getFullName());
            for (int i = 0; i < callable.getChildCount(); ++i) {
                Node child = (Node)callable.getChildAt(i);
                result.add(child.getFullName());
            }
        }
        return result;
    }

    protected void initForDisplay() {
        super.initForDisplay();
        if (!this.m_TextValue.getText().equals("" + this.getValue())) {
            this.m_TextValue.setText("" + this.getValue());
        }
        this.m_TextValue.setToolTipText(((RatReference)((Object)this.getValue())).getTipText());
        this.m_Tree.setFlowTree(FlowHelper.getTree((Container)this.m_CustomEditor));
        this.m_Tree.setItems(this.findRats());
        this.m_Tree.expandAll();
        this.m_Tree.selectNodeByName(this.m_TextValue.getText());
        this.m_TextValue.grabFocus();
    }
}

