/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.remotecontrolcenter.panels;

import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import adams.gui.tools.remotecontrolcenter.panels.AbstractRemoteFlowTab;
import adams.scripting.command.RemoteCommand;
import adams.scripting.command.RemoteCommandWithResponse;
import adams.scripting.command.flow.GetRatControlStatus;
import adams.scripting.command.flow.SendRatControlCommand;
import adams.scripting.responsehandler.AbstractResponseHandler;
import adams.scripting.responsehandler.ResponseHandler;
import com.googlecode.jfilechooserbookmarks.gui.BaseScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class RatsTab
extends AbstractRemoteFlowTab {
    private static final long serialVersionUID = 1059480818962711024L;
    protected JPanel m_PanelRats;
    protected JButton m_ButtonRefreshRats;

    protected void initGUI() {
        super.initGUI();
        JPanel panelAll = new JPanel(new BorderLayout());
        this.m_SplitPane.setBottomComponent((Component)panelAll);
        JPanel panelRefresh = new JPanel(new FlowLayout(0));
        panelAll.add((Component)panelRefresh, "North");
        this.m_ButtonRefreshRats = new JButton(GUIHelper.getIcon((String)"refresh.gif"));
        this.m_ButtonRefreshRats.addActionListener(e -> this.refreshRats());
        JLabel label = new JLabel("Refresh Rats status");
        label.setDisplayedMnemonic('R');
        label.setLabelFor(this.m_ButtonRefreshRats);
        panelRefresh.add(label);
        panelRefresh.add(this.m_ButtonRefreshRats);
        this.m_PanelRats = new JPanel(new BorderLayout());
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.m_PanelRats, "North");
        panelAll.add((Component)new BaseScrollPane((Component)panel), "Center");
    }

    protected void finishInit() {
        super.finishInit();
        this.clearStatus();
    }

    public String getTitle() {
        return "Rats";
    }

    public String getTabIcon() {
        return "rats.png";
    }

    protected void updateButtons() {
        super.updateButtons();
        this.m_ButtonRefreshRats.setEnabled(this.m_TableFlows.getSelectedRowCount() == 1);
    }

    public void refreshRats() {
        int[] ids = this.getSelectedFlowIDs();
        if (ids.length != 1) {
            return;
        }
        GetRatControlStatus cmd = new GetRatControlStatus();
        cmd.setID(ids[0]);
        this.sendCommandWithReponse((RemoteCommandWithResponse)cmd, (ResponseHandler)new RatStatusResponseHandler(this));
    }

    protected void clearStatus() {
        JLabel label = new JLabel("Nothing to display", 0);
        this.m_PanelRats.add((Component)label, "Center");
    }

    protected void updateRats(SpreadSheet status) {
        int i;
        this.clearStatus();
        if (status == null) {
            return;
        }
        this.m_PanelRats.removeAll();
        this.m_PanelRats.setLayout(new GridLayout(status.getRowCount(), 1));
        ArrayList<RatStatusPanel> panels = new ArrayList<RatStatusPanel>();
        for (i = 0; i < status.getRowCount(); ++i) {
            DataRow row = status.getRow(i);
            RatStatusPanel panel = new RatStatusPanel(this, row.getCell(0).toLong().intValue(), row.getCell(1).toString(), row.getCell(2).toBoolean(), row.getCell(3).toBoolean(), row.getCell(4).toBoolean(), row.getCell(5).toBoolean());
            this.m_PanelRats.add((Component)((Object)panel));
            panels.add(panel);
        }
        int max = 0;
        for (i = 0; i < panels.size(); ++i) {
            max = Math.max(max, (int)((RatStatusPanel)((Object)panels.get(i))).getLabelName().getPreferredSize().getWidth());
        }
        for (i = 0; i < panels.size(); ++i) {
            ((RatStatusPanel)((Object)panels.get(i))).getLabelName().setPreferredSize(new Dimension(max, ((RatStatusPanel)((Object)panels.get((int)i))).getLabelName().getPreferredSize().height));
        }
        this.m_PanelRats.invalidate();
        this.m_PanelRats.revalidate();
    }

    public static class RatStatusPanel
    extends BasePanel {
        private static final long serialVersionUID = -6090215566922900761L;
        protected RatsTab m_Owner;
        protected int m_ID;
        protected String m_Name;
        protected boolean m_Pausable;
        protected boolean m_Paused;
        protected boolean m_Stoppable;
        protected boolean m_Stopped;
        protected JLabel m_LabelName;
        protected JButton m_ButtonPauseResume;
        protected JButton m_ButtonStopStart;

        public RatStatusPanel(RatsTab owner, int id, String name, boolean pausable, boolean paused, boolean stoppable, boolean stopped) {
            this.m_Owner = owner;
            this.m_ID = id;
            this.m_Name = name;
            this.m_Pausable = pausable;
            this.m_Paused = paused;
            this.m_Stoppable = stoppable;
            this.m_Stopped = stopped;
            this.initGUI();
            this.finishInit();
        }

        protected void initGUI() {
            if (this.m_Owner == null) {
                return;
            }
            super.initGUI();
            this.setLayout(new FlowLayout(0));
            this.m_LabelName = new JLabel(this.m_Name);
            this.add(this.m_LabelName);
            if (this.m_Pausable) {
                this.m_ButtonPauseResume = new JButton(this.m_Paused ? GUIHelper.getIcon((String)"resume.gif") : GUIHelper.getIcon((String)"pause.gif"));
                this.m_ButtonPauseResume.addActionListener(e -> this.pauseResume());
                this.add(this.m_ButtonPauseResume);
            }
            if (this.m_Stoppable) {
                this.m_ButtonStopStart = new JButton(this.m_Stopped ? GUIHelper.getIcon((String)"run.gif") : GUIHelper.getIcon((String)"stop_blue.gif"));
                this.m_ButtonStopStart.addActionListener(e -> this.stopStart());
                this.add(this.m_ButtonStopStart);
            }
        }

        protected void finishInit() {
            if (this.m_Owner == null) {
                return;
            }
            super.finishInit();
        }

        public JLabel getLabelName() {
            return this.m_LabelName;
        }

        protected void pauseResume() {
            SendRatControlCommand cmd = new SendRatControlCommand();
            cmd.setID(this.m_ID);
            cmd.setCommand(this.m_Paused ? SendRatControlCommand.Command.RESUME : SendRatControlCommand.Command.PAUSE);
            cmd.setRat(this.m_Name);
            this.m_Owner.sendCommandWithReponse((RemoteCommandWithResponse)cmd);
            this.m_Owner.refreshRats();
        }

        protected void stopStart() {
            SendRatControlCommand cmd = new SendRatControlCommand();
            cmd.setID(this.m_ID);
            cmd.setCommand(this.m_Stopped ? SendRatControlCommand.Command.START : SendRatControlCommand.Command.STOP);
            cmd.setRat(this.m_Name);
            this.m_Owner.sendCommandWithReponse((RemoteCommandWithResponse)cmd);
            this.m_Owner.refreshRats();
        }
    }

    public static class RatStatusResponseHandler
    extends AbstractResponseHandler {
        private static final long serialVersionUID = 6205405220037007365L;
        protected RatsTab m_Tab;

        public RatStatusResponseHandler(RatsTab tab) {
            this.m_Tab = tab;
        }

        public String globalInfo() {
            return "Retrieves the Rats status.";
        }

        public void responseSuccessful(RemoteCommand cmd) {
            GetRatControlStatus cmdStatus;
            if (cmd instanceof GetRatControlStatus && (cmdStatus = (GetRatControlStatus)cmd).getResponsePayloadObjects().length > 0) {
                SpreadSheet status = (SpreadSheet)cmdStatus.getResponsePayloadObjects()[0];
                SwingUtilities.invokeLater(() -> this.m_Tab.updateRats(status));
            }
        }

        public void responseFailed(RemoteCommand cmd, String msg) {
            if (cmd instanceof GetRatControlStatus) {
                this.m_Tab.updateRats(null);
            }
        }
    }
}

