/*
 * Decompiled with CFR 0.152.
 */
package adams.scripting.command.flow;

import adams.core.Pausable;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.io.output.CsvSpreadSheetWriter;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.standalone.Rat;
import adams.flow.standalone.RatControl;
import adams.scripting.command.AbstractRemoteCommandOnFlowWithResponse;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;

public class GetRatControlStatus
extends AbstractRemoteCommandOnFlowWithResponse {
    private static final long serialVersionUID = -3350680106789169314L;
    public static final int COL_ID = 0;
    public static final int COL_RAT = 1;
    public static final int COL_PAUSABLE = 2;
    public static final int COL_PAUSED = 3;
    public static final int COL_STOPPABLE = 4;
    public static final int COL_STOPPED = 5;
    protected SpreadSheet m_Status;

    public String globalInfo() {
        return "Retrieves the status of Rat actors controlled by RatControl actors from a running/registered flow using its ID.\nUses a spreadsheet for the information with the following columns:\n- flowid -- the ID of the flow\n- rat -- the full name of the Rat actor\n- pausable -- whether the Rat can be paused\n- ispaused -- whether the Rat is currently paused\n- stoppable -- whether the Rat can be stopped\n- isstopped -- whether the Rat is currently stopped";
    }

    protected void initialize() {
        super.initialize();
        this.m_Status = null;
    }

    public String IDTipText() {
        return "The ID of the flow to query; -1 if to use the only one.";
    }

    public void setRequestPayload(byte[] value) {
    }

    public byte[] getRequestPayload() {
        return new byte[0];
    }

    public Object[] getRequestPayloadObjects() {
        return new Object[0];
    }

    public void setResponsePayload(byte[] value) {
        if (value.length == 0) {
            this.m_Status = null;
            return;
        }
        CsvSpreadSheetReader csv = new CsvSpreadSheetReader();
        SpreadSheet status = csv.read((Reader)new StringReader(new String(value)));
        if (status == null) {
            this.getLogger().severe("Failed to read status:\n" + new String(value));
        }
        this.m_Status = status;
    }

    public byte[] getResponsePayload() {
        if (this.m_Status == null) {
            return new byte[0];
        }
        StringWriter swriter = new StringWriter();
        CsvSpreadSheetWriter csv = new CsvSpreadSheetWriter();
        csv.write(this.m_Status, (Writer)swriter);
        return swriter.toString().getBytes();
    }

    protected void prepareResponsePayload() {
        super.prepareResponsePayload();
        Actor flow = this.retrieveFlow(false);
        if (flow != null) {
            DefaultSpreadSheet sheet = new DefaultSpreadSheet();
            HeaderRow row = sheet.getHeaderRow();
            row.addCell("0").setContent("flowid");
            row.addCell("1").setContent("rat");
            row.addCell("2").setContent("pausable");
            row.addCell("3").setContent("ispaused");
            row.addCell("4").setContent("stoppable");
            row.addCell("5").setContent("isstopped");
            for (Actor a : ActorUtils.enumerate((Actor)flow, (Class[])new Class[]{RatControl.class})) {
                RatControl rc = (RatControl)a;
                for (RatControl.AbstractControlState state : rc.getControlStates()) {
                    Object actor = state.getActor();
                    row = sheet.addRow();
                    row.addCell(0).setContent(this.m_ID);
                    row.addCell(1).setContent(state.getActor().getFullName());
                    row.addCell(2).setContent(Boolean.valueOf(state.isPausable()));
                    row.addCell(3).setContent(Boolean.valueOf(((Pausable)actor).isPaused()));
                    if (state instanceof RatControl.RatControlState) {
                        row.addCell(4).setContent(Boolean.valueOf(((RatControl.RatControlState)state).isStoppable()));
                        row.addCell(5).setContent(Boolean.valueOf(!((Rat)((Object)actor)).isRunnableActive()));
                        continue;
                    }
                    row.addCell(4).setContent(Boolean.valueOf(false));
                    row.addCell(5).setContent(Boolean.valueOf(false));
                }
            }
            this.m_Status = sheet;
        }
    }

    public Object[] getResponsePayloadObjects() {
        return new Object[]{this.m_Status};
    }
}

