/*
 * Decompiled with CFR 0.152.
 */
package adams.scripting.command.flow;

import adams.core.Pausable;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.standalone.Rat;
import adams.flow.standalone.RatControl;
import adams.scripting.command.AbstractRemoteCommandOnFlowWithResponse;

public class SendRatControlCommand
extends AbstractRemoteCommandOnFlowWithResponse {
    private static final long serialVersionUID = -3350680106789169314L;
    public static final String RESPONSE_SUCCESS = "Success";
    public static final String RESPONSE_NOT_FOUND = "Actor not found";
    public static final String RESPONSE_NO_SUPPORTED = "Command not supported";
    public static final String RESPONSE_ALREADY_PAUSED = "Already paused";
    public static final String RESPONSE_ALREADY_RUNNING = "Already running";
    public static final String RESPONSE_ALREADY_STOPPED = "Already stopped";
    protected String m_Rat;
    protected Command m_Command;
    protected String m_Response;

    public String globalInfo() {
        return "Sends a Rat command to a remote flow, identified by its ID.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("rat", "rat", (Object)"");
        this.m_OptionManager.add("command", "command", (Object)Command.PAUSE);
    }

    protected void initialize() {
        super.initialize();
        this.m_Response = null;
    }

    public String IDTipText() {
        return "The ID of the flow to oeprate on; -1 if to use the only one.";
    }

    public void setRat(String value) {
        this.m_Rat = value;
        this.reset();
    }

    public String getRat() {
        return this.m_Rat;
    }

    public String ratTipText() {
        return "The full name of the Rat actor to send the command to.";
    }

    public void setCommand(Command value) {
        this.m_Command = value;
        this.reset();
    }

    public Command getCommand() {
        return this.m_Command;
    }

    public String commandTipText() {
        return "The command to send.";
    }

    public void setRequestPayload(byte[] value) {
    }

    public byte[] getRequestPayload() {
        return new byte[0];
    }

    public Object[] getRequestPayloadObjects() {
        return new Object[0];
    }

    public void setResponsePayload(byte[] value) {
        if (value.length == 0) {
            this.m_Response = null;
            return;
        }
        this.m_Response = new String(value);
    }

    public byte[] getResponsePayload() {
        if (this.m_Response == null) {
            return new byte[0];
        }
        return this.m_Response.getBytes();
    }

    protected void prepareResponsePayload() {
        super.prepareResponsePayload();
        Actor flow = this.retrieveFlow(false);
        this.m_Response = RESPONSE_NOT_FOUND;
        if (flow != null) {
            for (Actor a : ActorUtils.enumerate((Actor)flow, (Class[])new Class[]{RatControl.class})) {
                RatControl rc = (RatControl)a;
                block7: for (RatControl.AbstractControlPanel panel : rc.getControlPanels()) {
                    Object actor = panel.getActor();
                    if (!actor.getFullName().equals(this.m_Rat)) continue;
                    switch (this.m_Command) {
                        case PAUSE: {
                            if (((Pausable)actor).isPaused()) {
                                this.m_Response = RESPONSE_ALREADY_PAUSED;
                                continue block7;
                            }
                            panel.pauseOrResume();
                            this.m_Response = RESPONSE_SUCCESS;
                            continue block7;
                        }
                        case RESUME: {
                            if (!((Pausable)actor).isPaused()) {
                                this.m_Response = RESPONSE_ALREADY_RUNNING;
                                continue block7;
                            }
                            panel.pauseOrResume();
                            this.m_Response = RESPONSE_SUCCESS;
                            continue block7;
                        }
                        case STOP: {
                            Rat rat;
                            if (panel instanceof RatControl.RatControlPanel) {
                                rat = (Rat)((Object)actor);
                                if (!rat.isRunnableActive()) {
                                    this.m_Response = RESPONSE_ALREADY_STOPPED;
                                    continue block7;
                                }
                                rat.stopRunnable();
                                this.m_Response = RESPONSE_SUCCESS;
                                continue block7;
                            }
                            this.m_Response = RESPONSE_NO_SUPPORTED;
                            continue block7;
                        }
                        case START: {
                            Rat rat;
                            if (panel instanceof RatControl.RatControlPanel) {
                                rat = (Rat)((Object)actor);
                                if (rat.isRunnableActive()) {
                                    this.m_Response = RESPONSE_ALREADY_RUNNING;
                                    continue block7;
                                }
                                rat.startRunnable();
                                this.m_Response = RESPONSE_SUCCESS;
                                continue block7;
                            }
                            this.m_Response = RESPONSE_NO_SUPPORTED;
                            continue block7;
                        }
                    }
                    this.m_Response = RESPONSE_NO_SUPPORTED;
                }
            }
        }
    }

    public Object[] getResponsePayloadObjects() {
        return new Object[]{this.m_Response};
    }

    public static enum Command {
        PAUSE,
        RESUME,
        STOP,
        START;

    }
}

