/*
 * Decompiled with CFR 0.152.
 */
package adams.terminal.menu.remotecommand;

import adams.core.Utils;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.scripting.command.RemoteCommand;
import adams.scripting.command.RemoteCommandWithResponse;
import adams.scripting.command.flow.GetRatControlStatus;
import adams.scripting.command.flow.SendRatControlCommand;
import adams.scripting.responsehandler.AbstractResponseHandler;
import adams.scripting.responsehandler.ResponseHandler;
import adams.terminal.application.AbstractTerminalApplication;
import adams.terminal.menu.remotecommand.AbstractRemoteFlowCommandAction;
import com.googlecode.lanterna.gui2.BorderLayout;
import com.googlecode.lanterna.gui2.Button;
import com.googlecode.lanterna.gui2.Component;
import com.googlecode.lanterna.gui2.Direction;
import com.googlecode.lanterna.gui2.GridLayout;
import com.googlecode.lanterna.gui2.Label;
import com.googlecode.lanterna.gui2.LayoutData;
import com.googlecode.lanterna.gui2.LayoutManager;
import com.googlecode.lanterna.gui2.LinearLayout;
import com.googlecode.lanterna.gui2.Panel;
import java.util.ArrayList;

public class Rats
extends AbstractRemoteFlowCommandAction {
    protected Panel m_PanelRats;
    protected Button m_ButtonRefreshRats;

    public Rats() {
    }

    public Rats(AbstractTerminalApplication owner) {
        super(owner);
    }

    public String getTitle() {
        return "Rats";
    }

    protected Panel createPanel() {
        Panel result = super.createPanel();
        Panel panelAll = new Panel((LayoutManager)new BorderLayout());
        this.m_PanelBottom.removeAllComponents();
        this.m_PanelBottom.addComponent((Component)panelAll);
        Panel panelRefresh = new Panel((LayoutManager)new LinearLayout(Direction.HORIZONTAL));
        panelAll.addComponent((Component)panelRefresh, (LayoutData)BorderLayout.Location.TOP);
        this.m_ButtonRefreshRats = new Button("Refresh");
        this.m_ButtonRefreshRats.addListener(button -> this.refreshRats());
        Label label = new Label("Refresh Rats status");
        panelRefresh.addComponent((Component)label);
        panelRefresh.addComponent((Component)this.m_ButtonRefreshRats);
        this.m_PanelRats = new Panel((LayoutManager)new BorderLayout());
        Panel panel = new Panel((LayoutManager)new BorderLayout());
        panel.addComponent((Component)this.m_PanelRats, (LayoutData)BorderLayout.Location.TOP);
        panelAll.addComponent((Component)panel, (LayoutData)BorderLayout.Location.CENTER);
        return result;
    }

    protected void updateButtons() {
        super.updateButtons();
        this.m_ButtonRefreshRats.setEnabled(this.getSelectedRows().length == 1);
    }

    public void focusRefreshRatsButton() {
        this.m_ButtonRefreshRats.takeFocus();
    }

    public void refreshRats() {
        int[] ids = this.getSelectedFlowIDs();
        if (ids.length != 1) {
            return;
        }
        GetRatControlStatus cmd = new GetRatControlStatus();
        cmd.setID(ids[0]);
        this.sendCommandWithReponse((RemoteCommandWithResponse)cmd, (ResponseHandler)new RatStatusResponseHandler(this));
    }

    protected void clearStatus() {
        Label label = new Label("Nothing to display");
        this.m_PanelRats.addComponent((Component)label, (LayoutData)BorderLayout.Location.CENTER);
    }

    protected void updateRats(SpreadSheet status) {
        int i;
        this.clearStatus();
        if (status == null) {
            return;
        }
        this.m_PanelRats.removeAllComponents();
        this.m_PanelRats.setLayoutManager((LayoutManager)new GridLayout(1));
        ArrayList<RatStatusPanel> panels = new ArrayList<RatStatusPanel>();
        for (i = 0; i < status.getRowCount(); ++i) {
            DataRow row = status.getRow(i);
            RatStatusPanel panel = new RatStatusPanel(this, row.getCell(0).toLong().intValue(), row.getCell(1).toString(), row.getCell(2).toBoolean(), row.getCell(3).toBoolean(), row.getCell(4).toBoolean(), row.getCell(5).toBoolean());
            this.m_PanelRats.addComponent((Component)panel);
            panels.add(panel);
        }
        int max = 0;
        for (i = 0; i < panels.size(); ++i) {
            max = Math.max(max, ((RatStatusPanel)((Object)panels.get(i))).getLabelName().getText().length());
        }
        for (i = 0; i < panels.size(); ++i) {
            ((RatStatusPanel)((Object)panels.get(i))).getLabelName().setText(Utils.padRight((String)((RatStatusPanel)((Object)panels.get(i))).getLabelName().getText(), (char)' ', (int)max));
        }
        this.m_PanelRats.invalidate();
    }

    public static class RatStatusPanel
    extends Panel {
        private static final long serialVersionUID = -6090215566922900761L;
        protected Rats m_Owner;
        protected int m_ID;
        protected String m_Name;
        protected boolean m_Pausable;
        protected boolean m_Paused;
        protected boolean m_Stoppable;
        protected boolean m_Stopped;
        protected Label m_LabelName;
        protected Button m_ButtonPauseResume;
        protected Button m_ButtonStopStart;

        public RatStatusPanel(Rats owner, int id, String name, boolean pausable, boolean paused, boolean stoppable, boolean stopped) {
            this.m_Owner = owner;
            this.m_ID = id;
            this.m_Name = name;
            this.m_Pausable = pausable;
            this.m_Paused = paused;
            this.m_Stoppable = stoppable;
            this.m_Stopped = stopped;
            this.initGUI();
        }

        protected void initGUI() {
            this.setLayoutManager((LayoutManager)new LinearLayout(Direction.HORIZONTAL));
            this.m_LabelName = new Label(this.m_Name);
            this.addComponent((Component)this.m_LabelName);
            if (this.m_Pausable) {
                this.m_ButtonPauseResume = new Button(this.m_Paused ? "Resume" : "Pause");
                this.m_ButtonPauseResume.addListener(button -> this.pauseResume());
                this.addComponent((Component)this.m_ButtonPauseResume);
            }
            if (this.m_Stoppable) {
                this.m_ButtonStopStart = new Button(this.m_Stopped ? "Run" : "Stop");
                this.m_ButtonStopStart.addListener(button -> this.stopStart());
                this.addComponent((Component)this.m_ButtonStopStart);
            }
        }

        public Label getLabelName() {
            return this.m_LabelName;
        }

        protected void pauseResume() {
            SendRatControlCommand cmd = new SendRatControlCommand();
            cmd.setID(this.m_ID);
            cmd.setCommand(this.m_Paused ? SendRatControlCommand.Command.RESUME : SendRatControlCommand.Command.PAUSE);
            cmd.setRat(this.m_Name);
            this.m_Owner.focusRefreshRatsButton();
            this.m_Owner.sendCommandWithReponse((RemoteCommandWithResponse)cmd);
            this.m_Owner.refreshRats();
        }

        protected void stopStart() {
            SendRatControlCommand cmd = new SendRatControlCommand();
            cmd.setID(this.m_ID);
            cmd.setCommand(this.m_Stopped ? SendRatControlCommand.Command.START : SendRatControlCommand.Command.STOP);
            cmd.setRat(this.m_Name);
            this.m_Owner.focusRefreshRatsButton();
            this.m_Owner.sendCommandWithReponse((RemoteCommandWithResponse)cmd);
            this.m_Owner.refreshRats();
        }
    }

    public static class RatStatusResponseHandler
    extends AbstractResponseHandler {
        private static final long serialVersionUID = 6205405220037007365L;
        protected Rats m_Command;

        public RatStatusResponseHandler(Rats command) {
            this.m_Command = command;
        }

        public String globalInfo() {
            return "Retrieves the Rats status.";
        }

        public void responseSuccessful(RemoteCommand cmd) {
            GetRatControlStatus cmdStatus;
            if (cmd instanceof GetRatControlStatus && (cmdStatus = (GetRatControlStatus)cmd).getResponsePayloadObjects().length > 0) {
                SpreadSheet status = (SpreadSheet)cmdStatus.getResponsePayloadObjects()[0];
                this.m_Command.updateRats(status);
            }
        }

        public void responseFailed(RemoteCommand cmd, String msg) {
            if (cmd instanceof GetRatControlStatus) {
                this.m_Command.updateRats(null);
            }
        }
    }
}

