/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * PollingRatInput.java
 * Copyright (C) 2014 University of Waikato, Hamilton, New Zealand
 */
package adams.flow.standalone.rats.input;


/**
 * Interface for {@link RatInput} schemes that buffer incoming data.
 * 
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision$
 */
public interface BufferedRatInput
  extends RatInput {

  /**
   * Sets the maximum number of items to buffer.
   *
   * @param value	the maximum number of items to buffer
   */
  public void setMaxBuffer(int value);

  /**
   * Returns the maximum number of items to buffer.
   *
   * @return		the maximum number of items to buffer
   */
  public int getMaxBuffer();

  /**
   * Returns the tip text for this property.
   *
   * @return 		tip text for this property suitable for
   * 			displaying in the GUI or for listing the options.
   */
  public String maxBufferTipText();

  /**
   * For buffering data.
   *
   * @param value	the data to buffer
   */
  public void bufferData(Object value);
}
